/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;

public class UserPreferences {
    private static final String dataMap = System.getProperty("user.home") + File.separator + ".GTI_BUILDER_OPTION" + File.separator + "GTI_Builder_Info.txt";
    private static UserPreferences system = null;
    private StringArray array;
    private boolean inited = false;
    private File file = null;

    private UserPreferences(File ff) {
        this.file = ff;
        this.init(ff);
    }

    private void init(File data) {
        if (!this.inited) {
            try {
                this.array = data.exists() ? new StringArray(new FileInputStream(data)) : new StringArray();
                this.inited = true;
            }
            catch (FileNotFoundException e) {
                new ErrorDialog(e);
            }
        }
    }

    public void clear() {
        if (this.inited) {
            this.array = null;
            this.inited = false;
        }
    }

    public static void clearSystem() {
        system = null;
    }

    public String getData(String key) {
        return (String)this.array.getContent(key);
    }

    public boolean setData(String key, String data) {
        if (!this.array.add(key, data)) {
            return this.array.change(key, data);
        }
        return true;
    }

    public void saveData() {
        byte[] data = this.array.getData();
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            fos.write(data);
            fos.close();
        }
        catch (IOException ioe) {
            new ErrorDialog(ioe);
        }
    }

    public void setStringArray(StringArray sa) {
        if (!this.file.getAbsolutePath().equals(dataMap)) {
            this.array = sa;
        }
    }

    public StringArray getStringArray() {
        if (!this.file.getAbsolutePath().equals(dataMap)) {
            return this.array;
        }
        return null;
    }

    public static UserPreferences getSystemPreferences() {
        if (system == null) {
            File fo = new File(System.getProperty("user.home") + File.separator + ".GTI_BUILDER_OPTION");
            if (!fo.exists()) {
                fo.mkdirs();
            }
            system = new UserPreferences(new File(dataMap));
        }
        return system;
    }

    public static UserPreferences loadPreferences(String dataBaseName) {
        Debug.print(System.getProperty("user.home") + File.separator + ".GTI_BUILDER_OPTION" + File.separator + "." + dataBaseName + ".txt");
        return new UserPreferences(new File(System.getProperty("user.home") + File.separator + ".GTI_BUILDER_OPTION" + File.separator + dataBaseName + ".txt"));
    }
}

