/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.NewPanel;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.project.ProjectNewPanel;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;

public class NewDialog
extends JDialog
implements ActionListener,
TreeSelectionListener {
    JTree jt = new JTree();
    JScrollPane jsp = new JScrollPane(this.jt);
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("New File...");
    DefaultMutableTreeNode project = new DefaultMutableTreeNode("New Project");
    NodeAndFile[] nodes = null;
    JButton next = new JButton();
    JButton back = new JButton();
    JButton cancel = new JButton();
    JPanel mother = new JPanel();
    ProjectManager pm = null;
    Hashtable map = new Hashtable();
    int step = 0;
    int sproject = 0;
    JComponent startup = null;
    NewPanel newPanel = null;
    EditorComponent comp = null;

    public NewDialog(ProjectManager pm) {
        super((Frame)MainWindow.getMainWindow(), true);
        this.pm = pm;
        this.init();
    }

    protected void init() {
        ResourceBundle menu = null;
        ResourceBundle comment = null;
        try {
            menu = ResourceBundle.getBundle("jp.sourceforge.gtibuilder.main.Bundle");
            comment = ResourceBundle.getBundle("jp.sourceforge.gtibuilder.io.FileStrings");
        }
        catch (MissingResourceException mre) {
            new ErrorDialog(mre);
            return;
        }
        this.setTitle(menu.getString("New.title"));
        this.root.setUserObject(menu.getString("New.root"));
        this.project.setUserObject(menu.getString("New.project"));
        this.next.setText(menu.getString("New.next"));
        this.back.setText(menu.getString("New.back"));
        this.cancel.setText(menu.getString("All.cancel"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewDialog.this.hide();
                NewDialog.this.dispose();
            }
        });
        this.back.addActionListener(this);
        this.back.setEnabled(false);
        this.next.setEnabled(false);
        this.next.addActionListener(this);
        ((Component)this).setSize(300, 200);
        this.root.add(this.project);
        if (this.pm.getProject() != null) {
            FileType[] types = FileDataBase.getAllCanNewTypes();
            int size = types.length;
            int loop = 0;
            this.nodes = new NodeAndFile[size];
            while (size > loop) {
                this.nodes[loop] = new NodeAndFile(new DefaultMutableTreeNode(types[loop].getNewComment()), types[loop]);
                this.root.add(this.nodes[loop].getTreeNode());
                ++loop;
            }
        }
        DefaultTreeModel model = new DefaultTreeModel(this.root);
        this.jt.setModel(model);
        this.getContentPane().setLayout(new BorderLayout());
        this.startup = this.jsp;
        this.getContentPane().add((Component)this.jsp, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(this.next);
        panel.add(this.back);
        panel.add(this.cancel);
        this.next.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.next);
        this.getContentPane().add((Component)panel, "South");
        this.jt.addTreeSelectionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.next) {
            if (this.step == 0) {
                this.showConfig();
            } else if (this.step == 1 && this.newPanel.next()) {
                this.dispose();
                if (this.sproject == 1) {
                    StringArray map = this.newPanel.getProperties();
                    map.add("WINDOW_MANAGER", this.pm);
                    this.pm.add(new Project(map));
                } else {
                    Project project = this.pm.getProject();
                    this.comp.init(this.newPanel);
                    Editor editor = new Editor(this.comp);
                    project.addEditor(editor);
                }
            }
        } else if (e.getSource() == this.back && this.step == 1 && this.newPanel.back()) {
            this.getContentPane().remove(this.newPanel);
            this.newPanel = null;
            this.getContentPane().add((Component)this.jsp, "Center");
            this.back.setEnabled(false);
            this.getContentPane().repaint();
            this.step = 0;
            this.sproject = 1;
        }
    }

    protected void showConfig() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jt.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node == this.project) {
            this.showNewProject();
            return;
        }
        int loop = 0;
        int size = this.nodes.length;
        while (loop < size) {
            if (this.nodes[loop].checkTreeNode(node)) {
                Debug.print("OK - checkNode");
                FileType ft = this.nodes[loop].getFileType();
                try {
                    try {
                        this.comp = (EditorComponent)ft.getInstance();
                        this.newPanel = this.comp.getNewFilePropertyPane(this);
                        this.newPanel.setFileType(ft);
                        this.getContentPane().remove(this.jsp);
                        this.getContentPane().add((Component)this.newPanel, "Center");
                        this.back.setEnabled(true);
                        ((JPanel)this.getContentPane()).revalidate();
                        this.step = 1;
                        this.sproject = 0;
                    }
                    catch (IllegalAccessException iae) {
                        new ErrorDialog(iae);
                        Object var9_6 = null;
                        break;
                    }
                    catch (InstantiationException ie) {
                        new ErrorDialog(ie);
                        Object var9_7 = null;
                        break;
                    }
                    catch (SecurityException se) {
                        new ErrorDialog(se);
                        Object var9_8 = null;
                        break;
                    }
                    Object var9_5 = null;
                    break;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    throw throwable;
                }
            }
            ++loop;
        }
    }

    protected void showNewProject() {
        this.newPanel = new ProjectNewPanel(this);
        this.getContentPane().remove(this.jsp);
        this.getContentPane().add((Component)this.newPanel, "Center");
        this.back.setEnabled(true);
        ((JPanel)this.getContentPane()).revalidate();
        this.step = 1;
        this.sproject = 1;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jt.getLastSelectedPathComponent();
        if (node == null) {
            this.next.setEnabled(false);
        } else {
            this.next.setEnabled(true);
        }
    }

    private class NodeAndFile {
        protected MutableTreeNode node;
        protected FileType ft;

        public NodeAndFile(MutableTreeNode node, FileType ft) {
            this.node = node;
            this.ft = ft;
        }

        public MutableTreeNode getTreeNode() {
            return this.node;
        }

        public FileType getFileType() {
            return this.ft;
        }

        public boolean checkTreeNode(MutableTreeNode check) {
            return this.node.equals(check);
        }

        public boolean checkFileType(FileType check) {
            return this.ft.equals(check);
        }
    }
}

