/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.io.UserPreferences;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.project.ProjectManager;

public class Preference
extends JDialog {
    ProjectManager manager = null;
    Object[][] fileType = null;
    Object[][] plugins = null;
    boolean changeFiletype = false;
    boolean changePlugin = false;
    private JButton add;
    private JCheckBox autoOpen;
    private JPanel boxLast;
    private JPanel buttons1;
    private JPanel buttons2;
    private JComboBox cLookAndFeel;
    private JButton cancel;
    private JPanel editorPlugin;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel lLookAndFeel;
    private JPanel lookAndFeel;
    private JButton ok;
    private JPanel plugin;
    private JButton remove;
    private JScrollPane sTabel1;
    private JScrollPane sTable2;
    private JPanel someOptions1;
    private JTable tEditorPlugin;
    private JTable tPlugin;
    private JTabbedPane tab;
    private JPanel uiPane;

    public Preference(Frame parent, boolean modal, ProjectManager manager) {
        super(parent, modal);
        this.manager = manager;
        this.fileType = new Object[FileDataBase.getAllTypes().length][5];
        int count = 0;
        while (count < FileDataBase.getAllTypes().length) {
            this.fileType[count][1] = FileDataBase.getAllTypes()[count].getMimeType();
            this.fileType[count][0] = FileDataBase.getAllTypes()[count].getExtension();
            this.fileType[count][2] = FileDataBase.getAllTypes()[count].getClazz().getName();
            this.fileType[count][3] = FileDataBase.getAllTypes()[count].getComment();
            this.fileType[count][4] = new Boolean(FileDataBase.getAllTypes()[count].getEnabled());
            ++count;
        }
        this.plugins = new Object[manager.getPluginManager().getPlugins().length][4];
        int count2 = 0;
        while (count2 < manager.getPluginManager().getPlugins().length) {
            this.plugins[count2][0] = manager.getPluginManager().getPlugins()[count2].getPluginName();
            this.plugins[count2][1] = manager.getPluginManager().getPlugins()[count2].getPluginVersion();
            this.plugins[count2][2] = manager.getPluginManager().getPlugins()[count2].getClass().getName();
            this.plugins[count2][3] = new Boolean(manager.getPluginManager().isEnablePlugin(count2));
            ++count2;
        }
        this.initComponents();
        this.tEditorPlugin.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                Preference.this.changeFiletype = true;
            }
        });
        this.tPlugin.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                Preference.this.changePlugin = true;
            }
        });
        this.getRootPane().setDefaultButton(this.ok);
    }

    private void initComponents() {
        this.tab = new JTabbedPane();
        this.uiPane = new JPanel();
        this.lookAndFeel = new JPanel();
        this.lLookAndFeel = new JLabel();
        this.cLookAndFeel = new JComboBox();
        this.someOptions1 = new JPanel();
        this.autoOpen = new JCheckBox();
        this.editorPlugin = new JPanel();
        this.sTabel1 = new JScrollPane();
        this.tEditorPlugin = new JTable();
        this.buttons1 = new JPanel();
        this.add = new JButton();
        this.remove = new JButton();
        this.plugin = new JPanel();
        this.sTable2 = new JScrollPane();
        this.tPlugin = new JTable();
        this.buttons2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.boxLast = new JPanel();
        this.ok = new JButton();
        this.cancel = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Preference.this.closeDialog(evt);
            }
        });
        this.uiPane.setLayout(new BoxLayout(this.uiPane, 1));
        this.lLookAndFeel.setText("Look and Feel");
        this.lookAndFeel.add(this.lLookAndFeel);
        this.cLookAndFeel.setModel(new DefaultComboBoxModel<String>(new String[]{"Cross Platform Look and Feel (Metal)", "Native Platform Look and Feel", "Moritf Look and Feel"}));
        this.cLookAndFeel.setSelectedIndex(Integer.parseInt(UserPreferences.getSystemPreferences().getData("LOOK_AND_FEEL")));
        this.cLookAndFeel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Preference.this.changeLookNadFeel(evt);
            }
        });
        this.lookAndFeel.add(this.cLookAndFeel);
        this.uiPane.add(this.lookAndFeel);
        this.autoOpen.setSelected(Boolean.valueOf(UserPreferences.getSystemPreferences().getData("AUTO_OPEN_PROJECT")));
        this.autoOpen.setText("Auto Open Project");
        this.someOptions1.add(this.autoOpen);
        this.uiPane.add(this.someOptions1);
        this.tab.addTab("UI Setting", this.uiPane);
        this.editorPlugin.setLayout(new BorderLayout());
        this.tEditorPlugin.setModel(new DefaultTableModel(this.fileType, new String[]{"Extension", "MIME Type", "Class", "Comment", "Enabled"}){
            Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = 5.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = 5.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = 5.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = 5.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = 5.class$("java.lang.Boolean")) : class$java$lang$Boolean};
            boolean[] canEdit = new boolean[]{false, false, false, false, true};
            static /* synthetic */ Class class$java$lang$String;
            static /* synthetic */ Class class$java$lang$Boolean;

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        this.tEditorPlugin.setDoubleBuffered(true);
        this.sTabel1.setViewportView(this.tEditorPlugin);
        this.editorPlugin.add((Component)this.sTabel1, "Center");
        this.buttons1.setLayout(new FlowLayout(2));
        this.add.setText("Add...");
        this.buttons1.add(this.add);
        this.remove.setText("Remove");
        this.remove.setEnabled(false);
        this.buttons1.add(this.remove);
        this.editorPlugin.add((Component)this.buttons1, "South");
        this.tab.addTab("File Type Setting", this.editorPlugin);
        this.plugin.setLayout(new BorderLayout());
        this.tPlugin.setModel(new DefaultTableModel(this.plugins, new String[]{"Plugin Name", "Version", "Class", "Enabled"}){
            Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = 6.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = 6.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = 6.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = 6.class$("java.lang.Boolean")) : class$java$lang$Boolean};
            boolean[] canEdit = new boolean[]{false, false, false, true};
            static /* synthetic */ Class class$java$lang$String;
            static /* synthetic */ Class class$java$lang$Boolean;

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        this.tPlugin.setDoubleBuffered(true);
        this.sTable2.setViewportView(this.tPlugin);
        this.plugin.add((Component)this.sTable2, "Center");
        this.buttons2.setLayout(new FlowLayout(2));
        this.jButton1.setText("Add");
        this.buttons2.add(this.jButton1);
        this.jButton2.setText("Remove");
        this.jButton2.setEnabled(false);
        this.buttons2.add(this.jButton2);
        this.plugin.add((Component)this.buttons2, "South");
        this.tab.addTab("Plugin Setting", this.plugin);
        this.getContentPane().add((Component)this.tab, "Center");
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Preference.this.okEvent(evt);
            }
        });
        this.boxLast.add(this.ok);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Preference.this.cancelEvent(evt);
            }
        });
        this.boxLast.add(this.cancel);
        this.getContentPane().add((Component)this.boxLast, "South");
        this.pack();
    }

    private void changeLookNadFeel(ActionEvent evt) {
        int index = this.cLookAndFeel.getSelectedIndex();
        try {
            if (index == 0) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else if (index == 1) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (index == 2) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MainWindow.getMainWindow().updataLookAndFeel();
        SwingUtilities.updateComponentTreeUI(this);
        UserPreferences.getSystemPreferences().setData("LOOK_AND_FEEL", Integer.toString(index));
    }

    private void cancelEvent(ActionEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void okEvent(ActionEvent evt) {
        int count;
        UserPreferences.getSystemPreferences().setData("AUTO_OPEN_PROJECT", String.valueOf(this.autoOpen.isSelected()));
        boolean showDialog = false;
        if (this.changeFiletype) {
            count = 0;
            while (count < this.tEditorPlugin.getModel().getRowCount()) {
                FileType ft = FileDataBase.getWithMime((String)this.tEditorPlugin.getModel().getValueAt(count, 1));
                ft.setEnabled((Boolean)this.tEditorPlugin.getModel().getValueAt(count, 4));
                ++count;
            }
            FileDataBase.saveFileTypeInfo();
        }
        if (this.changePlugin) {
            count = 0;
            while (count < this.tPlugin.getModel().getRowCount()) {
                int index = this.manager.getPluginManager().getPluginIndex((String)this.tPlugin.getModel().getValueAt(count, 0));
                this.manager.getPluginManager().setEnablePlugin(index, (Boolean)this.tPlugin.getModel().getValueAt(count, 3));
                ++count;
            }
            this.manager.getPluginManager().savePluginDataBase();
        }
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }
}

