/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.io.UnsupportedEncodingException;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.editor.TextColoring;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.DefaultNewPanel;
import jp.sourceforge.gtibuilder.main.NewPanel;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class TextEditor
implements EditorComponent,
DocumentListener {
    private JTextPane jtp = new JTextPane();
    private JScrollPane sp = new JScrollPane(this.jtp);
    private boolean inited = false;
    private boolean autoCheck = false;
    private FileType ft = null;
    private boolean edited = false;
    private String name = null;
    private String pack = null;

    public void insertUpdate(final DocumentEvent documentEvent) {
        new Thread(){

            public void run() {
                if (documentEvent.getLength() == 1) {
                    char c = TextEditor.this.jtp.getText().toCharArray()[documentEvent.getOffset()];
                    try {
                        if (c == '\t') {
                            TextEditor.this.jtp.getDocument().remove(documentEvent.getOffset(), 1);
                            TextEditor.this.jtp.getDocument().insertString(documentEvent.getOffset(), "    ", null);
                            TextEditor.this.jtp.setCaretPosition(TextEditor.this.jtp.getCaretPosition() + 3);
                        } else if (c != '\n' && c == '\\') {
                            TextEditor.this.jtp.getDocument().remove(documentEvent.getOffset(), 1);
                            TextEditor.this.jtp.getDocument().insertString(documentEvent.getOffset(), "\\", null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }.start();
        this.edited = true;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.edited = true;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public boolean readData(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8");
            this.jtp.setText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            new ErrorDialog(unsupportedEncodingException).show();
            return false;
        }
        return true;
    }

    public byte[] getData() {
        String string = this.jtp.getText();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            new ErrorDialog(unsupportedEncodingException).show();
            return null;
        }
    }

    public FileType getFileType() {
        this.isInited();
        return this.ft;
    }

    public boolean setFileType(FileType fileType) {
        this.isInited();
        if (this.isSupportedType(fileType)) {
            this.ft = fileType;
            return true;
        }
        return false;
    }

    public boolean isAutoCheckProperty() {
        this.isInited();
        return this.autoCheck;
    }

    public String getFileName() {
        this.isInited();
        return this.name;
    }

    public boolean setFileName(String string) {
        this.isInited();
        if (this.isAutoCheckProperty()) {
            return false;
        }
        this.name = string;
        return true;
    }

    public String getDirectory() {
        this.isInited();
        return this.pack;
    }

    public boolean setDirectory(String string) {
        this.isInited();
        if (this.isAutoCheckProperty()) {
            return false;
        }
        this.pack = string;
        return true;
    }

    public boolean close() {
        int n;
        this.isInited();
        return !this.edited || (n = JOptionPane.showConfirmDialog(null, "Are you sure close this file?", "Close", 0)) != 1;
    }

    public JMenu[] usingMenu() {
        return null;
    }

    public boolean usingEditMenu() {
        return true;
    }

    public void copy() {
        this.isInited();
        this.jtp.copy();
    }

    public void cut() {
        this.isInited();
        this.jtp.cut();
    }

    public void delete() {
        this.isInited();
        String string = this.jtp.getText().substring(0, this.jtp.getSelectionStart());
        String string2 = this.jtp.getText().substring(this.jtp.getSelectionEnd());
        this.jtp.setText(string + string2);
    }

    public void paste() {
        this.isInited();
        this.jtp.paste();
    }

    public void undo() {
        this.isInited();
    }

    public void redo() {
        this.isInited();
    }

    public void saved() {
        this.edited = false;
    }

    public NewPanel getNewFilePropertyPane() {
        return new DefaultNewPanel();
    }

    public JPanel getFilePropertyPane() {
        this.isInited();
        return null;
    }

    public FileType[] getSupportedTypes() {
        this.isInited();
        FileType[] fileTypeArray = new FileType[]{FileDataBase.getWithMime("text/plain"), FileDataBase.getWithMime("text/x-java-source")};
        return fileTypeArray;
    }

    public boolean isSupportedType(FileType fileType) {
        this.isInited();
        String string = fileType.getMimeType();
        return string.startsWith("text");
    }

    public Component getComponent() {
        this.isInited();
        return this.sp;
    }

    public void init(NewPanel newPanel) {
        this.jtp.getDocument().addDocumentListener(this);
        StringArray stringArray = newPanel.getProperties();
        this.name = (String)stringArray.getContent("NAME");
        this.pack = (String)stringArray.getContent("DIRECTORY");
        this.ft = newPanel.getFileType();
        this.init();
        if (this.ft == FileDataBase.getWithExtension("java")) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/*\n");
            stringBuffer.append(" *  " + this.getFileName() + "\n");
            stringBuffer.append(" */\n");
            stringBuffer.append("\n");
            if (!this.getDirectory().equals("")) {
                stringBuffer.append("package " + TextBuffer.replace(this.getDirectory(), "/", ".") + ";\n");
                stringBuffer.append("\n");
            }
            stringBuffer.append("public class " + this.getFileName().substring(0, this.getFileName().lastIndexOf(46)) + " {\n");
            stringBuffer.append("\n");
            stringBuffer.append("}\n");
            this.jtp.setText(stringBuffer.toString());
        }
    }

    public void init(StringArray stringArray, FileType fileType) {
        this.jtp.getDocument().addDocumentListener(this);
        this.name = (String)stringArray.getContent("NAME");
        this.pack = (String)stringArray.getContent("DIRECTORY");
        this.ft = fileType;
        this.init();
    }

    private void init() {
        this.inited = true;
        if (this.ft == FileDataBase.getWithExtension("java")) {
            new TextColoring(this.jtp);
        }
    }

    private void isInited() {
        if (!this.inited) {
            throw new IllegalStateException();
        }
    }

    public Dialog getFilePreference() {
        return null;
    }
}

