/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.build;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.plugin.Plugin;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class Export
implements Plugin,
ActionListener {
    JMenuItem export = new JMenuItem("Export");
    private ProjectManager manager = null;

    public Export() {
        this.export.addActionListener(this);
    }

    public JMenu getJMenu() {
        return null;
    }

    public JMenuItem[] getJMenuItem() {
        JMenuItem[] jMenuItemArray = new JMenuItem[]{this.export};
        return jMenuItemArray;
    }

    public int getMenuAddPoint() {
        return 4;
    }

    public String getPluginName() {
        return "Export";
    }

    public String getPluginVersion() {
        return "Final";
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.manager = projectManager;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)MainWindow.getMainWindow(), "Export", 1);
        fileDialog.show();
        Debug.print(fileDialog.getDirectory() + fileDialog.getFile());
        File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
        this.export(file);
    }

    public void export(File file) {
        Debug.print(file);
        file.mkdirs();
        ProjectFile[] projectFileArray = this.manager.getProject().getProjectFiles();
        for (int i = 0; projectFileArray.length > i; ++i) {
            String string = File.separator + TextBuffer.replace(projectFileArray[i].getDirectory(), "/", File.separator);
            File file2 = new File(file.getAbsolutePath() + string);
            file2.mkdirs();
            File file3 = new File(file2.getAbsolutePath() + File.separator + projectFileArray[i].getFileName());
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                fileOutputStream.write(projectFileArray[i].getData());
                fileOutputStream.close();
                continue;
            }
            catch (IOException iOException) {
                Debug.print(iOException);
                new ErrorDialog(iOException).show();
            }
        }
    }
}

