/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.project;

import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.io.ProjectWriter;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.NewWindowListener;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.main.WindowManager;
import jp.sourceforge.gtibuilder.project.AddFileDialog;
import jp.sourceforge.gtibuilder.project.NameUpdataEvent;
import jp.sourceforge.gtibuilder.project.NameUpdataListener;
import jp.sourceforge.gtibuilder.project.ProjectPreference;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class Project
extends JPanel
implements ActionListener,
MouseListener {
    public static final String MASTER = "MASTER";
    public static final String NAME = "NAME";
    public static final String COPYRIGHT = "COPYRIGHT";
    public static final String ORGANIZATION = "ORGANIZATION";
    public static final String COMMENT = "COMMENT";
    public static final String WINDOW_MANAGER = "WINDOW_MANAGER";
    public static final String MAIN_CLASS = "MAIN_CLASS";
    private JSplitPane sp = null;
    private JDesktopPane dp = null;
    private JTree jt = null;
    private Vector editors = new Vector();
    private DefaultMutableTreeNode node = null;
    private DefaultTreeModel model = null;
    private File file = null;
    private StringArray infomation = new StringArray();
    private Timer timer = null;
    private WindowListener listener = null;
    private NewWindowListener newListener = null;
    private Vector listeners = new Vector();
    private int newx = 0;
    private int newy = 0;

    public Project(StringArray stringArray) {
        this.timer = new Timer(1000, this);
        this.infomation.add(NAME, (String)stringArray.getContent(NAME));
        this.infomation.add(COPYRIGHT, (String)stringArray.getContent(COPYRIGHT));
        this.infomation.add(ORGANIZATION, (String)stringArray.getContent(ORGANIZATION));
        this.infomation.add(MASTER, (String)stringArray.getContent(MASTER));
        this.infomation.add(COMMENT, (String)stringArray.getContent(COMMENT));
        this.dp = new JDesktopPane();
        this.node = new DefaultMutableTreeNode(this.getProjectName());
        this.model = new DefaultTreeModel(this.node);
        this.jt = new JTree(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.jt);
        this.sp = new JSplitPane(1, false, jScrollPane, this.dp);
        this.sp.setDividerLocation(200);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.sp);
        this.listener = new WindowListener();
        this.newListener = (NewWindowListener)stringArray.getContent(WINDOW_MANAGER);
        this.timer.start();
        this.jt.addMouseListener(this);
    }

    public Project(byte[] byArray, WindowManager windowManager) {
        this.timer = new Timer(1000, this);
        this.setProjectInfo(byArray);
        this.dp = new JDesktopPane();
        this.node = new DefaultMutableTreeNode(this.getProjectName());
        this.model = new DefaultTreeModel(this.node);
        this.jt = new JTree(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.jt);
        this.sp = new JSplitPane(1, false, jScrollPane, this.dp);
        this.sp.setDividerLocation(200);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.sp);
        this.listener = new WindowListener();
        this.newListener = windowManager;
        this.timer.start();
        this.jt.addMouseListener(this);
    }

    public String getMainClass() {
        return (String)this.infomation.getContent(MAIN_CLASS);
    }

    public String getCopyright() {
        return (String)this.infomation.getContent(COPYRIGHT);
    }

    public String getProjectName() {
        return (String)this.infomation.getContent(NAME);
    }

    public String getOrg() {
        return (String)this.infomation.getContent(ORGANIZATION);
    }

    public String getComment() {
        return (String)this.infomation.getContent(COMMENT);
    }

    public String getMaster() {
        return (String)this.infomation.getContent(MASTER);
    }

    public File getSaveFile() {
        return this.file;
    }

    public byte[] getProjectInfo() {
        return this.infomation.getData();
    }

    public boolean setProjectInfo(byte[] byArray) {
        StringArray stringArray = new StringArray(new ByteArrayInputStream(byArray));
        this.infomation.copyArray(stringArray);
        return true;
    }

    public void setMainClass(String string) {
        this.infomation.add(MAIN_CLASS, string);
    }

    public void setCopyright(String string) {
        this.infomation.add(COPYRIGHT, string);
    }

    public void setProjectName(String string) {
        this.infomation.add(NAME, string);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((NameUpdataListener)enumeration.nextElement()).updataName(new NameUpdataEvent((Object)this, string));
        }
    }

    public void setOrg(String string) {
        this.infomation.add(ORGANIZATION, string);
    }

    public void setMaster(String string) {
        this.infomation.add(MASTER, string);
    }

    public void setComment(String string) {
        this.infomation.add(COMMENT, string);
    }

    public void setInfomation(String string, String string2) {
        if (!this.infomation.add(string, string2)) {
            this.infomation.change(string, string2);
        }
    }

    public String getInfomation(String string) {
        return (String)this.infomation.getContent(string);
    }

    public void setSaveFile(File file) {
        this.file = file;
    }

    public void addEditor(Editor editor) {
        editor.addInternalFrameListener(this.listener);
        this.newListener.addWindow(editor, this);
        editor.setBounds(this.newx, this.newy, 400, 300);
        this.newx += 40;
        this.newy += 40;
        this.editors.addElement(editor);
        this.dp.add(editor);
        editor.setVisible(true);
        String[] stringArray = null;
        stringArray = TextBuffer.cutString(editor.getDirectory(), "/");
        DefaultMutableTreeNode defaultMutableTreeNode = this.node;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length && !stringArray[i].equals(""); ++i) {
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                enumeration = defaultMutableTreeNode.children();
                TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
                boolean bl = false;
                while (enumeration.hasMoreElements() && !bl) {
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (!stringArray[i].equals(defaultMutableTreeNode2.getUserObject())) continue;
                    defaultMutableTreeNode = defaultMutableTreeNode2;
                    bl = true;
                    break;
                }
                if (!bl) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(stringArray[i]);
                    defaultMutableTreeNode.add(defaultMutableTreeNode3);
                    defaultMutableTreeNode = defaultMutableTreeNode3;
                }
                editor.toFront();
            }
        }
        defaultMutableTreeNode2 = new FileNode(editor);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.model.reload();
        this.jt.treeDidChange();
    }

    public void addInternalFrame(JInternalFrame jInternalFrame) {
        this.dp.add(jInternalFrame);
    }

    public void removeIntarnalFrame(JInternalFrame jInternalFrame) {
        ((Container)this.dp).remove(jInternalFrame);
    }

    public void addFile() {
        FileDialog fileDialog = new FileDialog((Frame)MainWindow.getMainWindow(), "Add File", 0);
        fileDialog.show();
        File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
        this.addFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addFile(File file) {
        block13: {
            FileInputStream fileInputStream;
            block12: {
                fileInputStream = null;
                fileInputStream = new FileInputStream(file);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 0;
                while ((n = fileInputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                final byte[] byArray = byteArrayOutputStream.toByteArray();
                String string = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(46) + 1);
                final FileType fileType = FileDataBase.getWithExtension(string);
                final EditorComponent editorComponent = fileType.getEditor();
                if (editorComponent == null) break block12;
                final AddFileDialog addFileDialog = new AddFileDialog(file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(47) + 1));
                addFileDialog.show();
                addFileDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent windowEvent) {
                        editorComponent.init(addFileDialog.getMap(), fileType);
                        editorComponent.readData(byArray);
                        Project.this.addEditor(new Editor(editorComponent));
                    }
                });
            }
            Object var11_11 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block13;
            }
            catch (Exception exception) {
                Debug.print(exception);
                new ErrorDialog(exception).show();
            }
            break block13;
            {
                catch (IOException iOException) {
                    new ErrorDialog(iOException).show();
                    Object var11_12 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block13;
                    }
                    catch (Exception exception) {
                        Debug.print(exception);
                        new ErrorDialog(exception).show();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    Debug.print(exception);
                    new ErrorDialog(exception).show();
                }
                throw throwable;
            }
        }
    }

    public ProjectFile[] getProjectFiles() {
        return this.getEditors();
    }

    protected Editor[] getEditors() {
        Editor[] editorArray = new Editor[this.editors.size()];
        int n = editorArray.length;
        for (int i = 0; i < n; ++i) {
            editorArray[i] = (Editor)this.editors.elementAt(i);
        }
        return editorArray;
    }

    protected Editor getSelectedEditor() {
        JInternalFrame jInternalFrame = this.listener.getSelectedFrame();
        if (jInternalFrame == null) {
            return null;
        }
        if (jInternalFrame instanceof Editor) {
            return (Editor)jInternalFrame;
        }
        return null;
    }

    public void showFilePreference() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().showFilePreference();
        }
    }

    public void showProjectPreference() {
        ProjectPreference projectPreference = new ProjectPreference(this);
        projectPreference.show();
    }

    public void copy() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().copy();
        }
    }

    public void cut() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().cut();
        }
    }

    public void paste() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().paste();
        }
    }

    public void delete() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().delete();
        }
    }

    public void undo() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().undo();
        }
    }

    public void redo() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().redo();
        }
    }

    public void task() {
    }

    public void save() {
        if (this.file == null) {
            this.saveAs();
        }
        final File file = this.file;
        final Project project = this;
        new Thread(){

            public void run() {
                ProjectWriter.save(file, project);
            }
        }.start();
    }

    public void saveAs() {
        FileDialog fileDialog = new FileDialog((Frame)MainWindow.getMainWindow(), "Save Project", 1);
        fileDialog.setFile(this.getProjectName() + ".gtb");
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            this.file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            this.save();
        }
    }

    public void close() {
        int n;
        ProjectFile[] projectFileArray = this.getProjectFiles();
        boolean bl = false;
        for (n = 0; n < projectFileArray.length; ++n) {
            if (!projectFileArray[n].isEdited()) continue;
            bl = true;
        }
        if (bl && (n = JOptionPane.showConfirmDialog(MainWindow.getMainWindow(), "This project is not saved.Do you want to save this project?", "Closing " + this.getProjectName(), 0, 2)) == 0) {
            this.save();
        }
        for (n = 0; n < projectFileArray.length; ++n) {
            ((Editor)projectFileArray[n]).dispose();
        }
    }

    public void addNameUpdataListener(NameUpdataListener nameUpdataListener) {
        if (this.listeners.indexOf(nameUpdataListener) != -1) {
            return;
        }
        this.listeners.addElement(nameUpdataListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            this.task();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.jt.getLastSelectedPathComponent();
        if (defaultMutableTreeNode instanceof FileNode && mouseEvent.getClickCount() == 2) {
            ((Editor)((FileNode)defaultMutableTreeNode).getProjectFile()).show();
            ((Editor)((FileNode)defaultMutableTreeNode).getProjectFile()).toFront();
            this.dp.setSelectedFrame((Editor)((FileNode)defaultMutableTreeNode).getProjectFile());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class FileNode
    extends DefaultMutableTreeNode
    implements NameUpdataListener {
        private ProjectFile file = null;

        public FileNode(ProjectFile projectFile) {
            this.file = projectFile;
            this.setUserObject(projectFile.getFileName());
        }

        public void updataName(NameUpdataEvent nameUpdataEvent) {
            this.setUserObject(this.file.getFileName());
        }

        public ProjectFile getProjectFile() {
            return this.file;
        }
    }

    class WindowListener
    implements InternalFrameListener {
        private JInternalFrame selectedFrame = null;

        WindowListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            this.selectedFrame = (JInternalFrame)internalFrameEvent.getSource();
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            if (this.selectedFrame == internalFrameEvent.getSource()) {
                this.selectedFrame = null;
            }
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public JInternalFrame getSelectedFrame() {
            return this.selectedFrame;
        }
    }
}

