/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.Serializable;

public class FieldLayout
implements LayoutManager,
Serializable {
    public static final String HEADLINE = "HEADLINE";
    public static final String CONTENT = "CONTENT";
    public static final int TOP = 1;
    public static final int CENTER = 2;
    public static final int BOTTOM = 3;
    private Component headline = null;
    private Component content = null;
    private int layoutStyle = 3;

    public FieldLayout() {
        this.layoutStyle = 2;
    }

    public FieldLayout(int n) {
        this.layoutStyle = n;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals(HEADLINE)) {
            this.headline = component;
        } else if (string.equals(CONTENT)) {
            this.content = component;
        }
    }

    public void removeLayoutComponent(Component component) {
        if (this.headline == component) {
            this.headline = null;
        }
        if (this.content == component) {
            this.content = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        if (this.headline == null || this.content == null) {
            return new Dimension(0, 0);
        }
        int n = 0;
        int n2 = 0;
        n = this.headline.getPreferredSize().width + this.content.getPreferredSize().width;
        int n3 = this.headline.getPreferredSize().height;
        int n4 = this.content.getPreferredSize().height;
        n2 = n3 == n4 ? n3 : (n3 > n4 ? n3 : n4);
        return new Dimension(n, n2);
    }

    public Dimension minimumLayoutSize(Container container) {
        if (this.headline == null || this.content == null) {
            return new Dimension(0, 0);
        }
        int n = 0;
        int n2 = 0;
        n = this.headline.getMinimumSize().width + this.content.getPreferredSize().width;
        int n3 = this.headline.getMinimumSize().height;
        int n4 = this.content.getMinimumSize().height;
        n2 = n3 == n4 ? n3 : (n3 > n4 ? n3 : n4);
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        if (this.headline == null || this.content == null) {
            return;
        }
        int n = container.getSize().height;
        int n2 = container.getSize().width;
        Dimension dimension = new Dimension();
        Dimension dimension2 = new Dimension();
        if (this.headline.getPreferredSize().height >= n) {
            this.headline.setLocation(0, 0);
            dimension.height = n;
        } else {
            if (this.layoutStyle == 1) {
                this.headline.setLocation(0, 0);
            } else if (this.layoutStyle == 2) {
                this.headline.setLocation(0, (n - this.headline.getPreferredSize().height) / 2);
            } else {
                this.headline.setLocation(0, n - this.headline.getPreferredSize().height);
            }
            dimension.height = this.headline.getPreferredSize().height;
        }
        dimension.width = this.headline.getPreferredSize().width;
        if (this.content.getPreferredSize().height >= n) {
            this.content.setLocation(dimension.width, 0);
            dimension2.height = n;
        } else {
            if (this.layoutStyle == 1) {
                this.content.setLocation(dimension.width, 0);
            } else if (this.layoutStyle == 2) {
                this.content.setLocation(dimension.width, (n - this.content.getPreferredSize().height) / 2);
            } else {
                this.content.setLocation(dimension.width, n - this.content.getPreferredSize().height);
            }
            dimension2.height = this.content.getPreferredSize().height;
        }
        dimension2.width = n2 - dimension.width;
        this.content.setSize(dimension2);
        this.headline.setSize(dimension);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            this.addLayoutComponent((String)object, component);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        if (this.headline == null || this.content == null) {
            return new Dimension(0, 0);
        }
        int n = 0;
        int n2 = 0;
        n = this.headline.getMaximumSize().width + this.content.getMaximumSize().width;
        int n3 = this.headline.getMaximumSize().height;
        int n4 = this.content.getMaximumSize().height;
        n2 = n3 == n4 ? n3 : (n3 > n4 ? n3 : n4);
        return new Dimension(n, n2);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }
}

