/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jp.sourceforge.gtibuilder.editor.TextColoring;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.UserPreferences;
import jp.sourceforge.gtibuilder.main.Help;
import jp.sourceforge.gtibuilder.main.Main;
import jp.sourceforge.gtibuilder.main.Preference;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;

public class MainWindow
extends JFrame
implements ActionListener,
WindowListener {
    private JMenuBar menuBar = new JMenuBar();
    private ProjectManager pm = null;
    private JMenu mFile = new JMenu();
    private JMenuItem mNew = new JMenuItem();
    private JMenuItem mOpen = new JMenuItem();
    private JMenuItem mSave = new JMenuItem();
    private JMenuItem mSaveAs = new JMenuItem();
    private JMenuItem mClose = new JMenuItem();
    private JMenuItem mPrint = new JMenuItem();
    private JMenuItem mQuit = new JMenuItem();
    private JMenuItem mRestart = new JMenuItem();
    private JMenu mEdit = new JMenu();
    private JMenuItem mUndo = new JMenuItem();
    private JMenuItem mRedo = new JMenuItem();
    private JMenuItem mCut = new JMenuItem();
    private JMenuItem mCopy = new JMenuItem();
    private JMenuItem mPaste = new JMenuItem();
    private JMenuItem mDelete = new JMenuItem();
    private JMenu mProject = new JMenu();
    private JMenuItem mProjectPreference = new JMenuItem();
    private JMenuItem mFilePreference = new JMenuItem();
    private JMenuItem mAddFile = new JMenuItem();
    private JMenuItem mRemoveFile = new JMenuItem();
    private JMenu mTools = new JMenu();
    private JMenuItem mPreference = new JMenuItem();
    private JMenu mWindow = new JMenu();
    private JMenu mHelp = new JMenu();
    private JMenuItem mInfomation = new JMenuItem();
    private JPanel st = new JPanel();
    private JLabel sta = new JLabel();
    private JProgressBar sb = new JProgressBar();
    private static MainWindow mainFrame = null;

    public MainWindow() {
        super("GTI Builder");
        mainFrame = this;
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        boolean bl = false;
        if (System.getProperty("os.name").equals("Mac OS X")) {
            dimension.height -= 22;
            bl = true;
        }
        ((Component)this).setSize(dimension);
        ((Component)this).setLocation(0, 0);
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("jp.sourceforge.gtibuilder.main.Bundle");
        }
        catch (MissingResourceException missingResourceException) {
            new ErrorDialog(missingResourceException);
            return;
        }
        this.pm = new ProjectManager();
        this.mWindow = this.pm.getWindowManager().getWindowMenu();
        this.mFile.setText(resourceBundle.getString("Menu.file"));
        this.mNew.setText(resourceBundle.getString("Menu.new"));
        this.mOpen.setText(resourceBundle.getString("Menu.open"));
        this.mSave.setText(resourceBundle.getString("Menu.save"));
        this.mSaveAs.setText(resourceBundle.getString("Menu.saveAs"));
        this.mClose.setText(resourceBundle.getString("Menu.close"));
        this.mPrint.setText(resourceBundle.getString("Menu.print"));
        this.mQuit.setText(resourceBundle.getString("Menu.quit"));
        this.mRestart.setText(resourceBundle.getString("Menu.restart"));
        this.mEdit.setText(resourceBundle.getString("Menu.edit"));
        this.mUndo.setText(resourceBundle.getString("Menu.undo"));
        this.mRedo.setText(resourceBundle.getString("Menu.redo"));
        this.mCut.setText(resourceBundle.getString("Menu.cut"));
        this.mCopy.setText(resourceBundle.getString("Menu.copy"));
        this.mPaste.setText(resourceBundle.getString("Menu.paste"));
        this.mDelete.setText(resourceBundle.getString("Menu.delete"));
        this.mProject.setText(resourceBundle.getString("Menu.project"));
        this.mProjectPreference.setText(resourceBundle.getString("Menu.projectPreference"));
        this.mFilePreference.setText(resourceBundle.getString("Menu.filePreference"));
        this.mAddFile.setText(resourceBundle.getString("Menu.addFile"));
        this.mRemoveFile.setText(resourceBundle.getString("Menu.removeFile"));
        this.mTools.setText(resourceBundle.getString("Menu.tools"));
        this.mPreference.setText(resourceBundle.getString("Menu.preference"));
        this.mWindow.setText(resourceBundle.getString("Menu.window"));
        this.mHelp.setText(resourceBundle.getString("Menu.help"));
        this.mInfomation.setText(resourceBundle.getString("Menu.infomation"));
        this.menuBar.add(this.mFile);
        this.menuBar.add(this.mEdit);
        this.menuBar.add(this.mProject);
        this.menuBar.add(this.mTools);
        this.menuBar.add(this.mWindow);
        this.menuBar.add(this.mHelp);
        this.mFile.add(this.mNew);
        this.mNew.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mFile.addSeparator();
        this.mFile.add(this.mOpen);
        this.mOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mFile.addSeparator();
        this.mFile.add(this.mSave);
        this.mFile.add(this.mSaveAs);
        this.mFile.addSeparator();
        this.mFile.add(this.mClose);
        this.mFile.addSeparator();
        if (!bl) {
            this.mFile.add(this.mQuit);
        }
        this.mFile.add(this.mRestart);
        this.mEdit.add(this.mUndo);
        this.mEdit.add(this.mRedo);
        this.mEdit.addSeparator();
        this.mEdit.add(this.mCut);
        this.mEdit.add(this.mCopy);
        this.mEdit.add(this.mPaste);
        this.mEdit.addSeparator();
        this.mEdit.add(this.mDelete);
        this.mProject.add(this.mProjectPreference);
        this.mProject.add(this.mFilePreference);
        this.mProject.addSeparator();
        this.mProject.add(this.mAddFile);
        this.mProject.add(this.mRemoveFile);
        this.mTools.add(this.mPreference);
        this.mHelp.add(this.mInfomation);
        this.mNew.addActionListener(this);
        this.mOpen.addActionListener(this);
        this.mSave.addActionListener(this);
        this.mSaveAs.addActionListener(this);
        this.mClose.addActionListener(this);
        this.mPrint.addActionListener(this);
        this.mQuit.addActionListener(this);
        this.mRestart.addActionListener(this);
        this.mUndo.addActionListener(this);
        this.mRedo.addActionListener(this);
        this.mCut.addActionListener(this);
        this.mCopy.addActionListener(this);
        this.mPaste.addActionListener(this);
        this.mDelete.addActionListener(this);
        this.mProjectPreference.addActionListener(this);
        this.mFilePreference.addActionListener(this);
        this.mAddFile.addActionListener(this);
        this.mRemoveFile.addActionListener(this);
        this.mPreference.addActionListener(this);
        this.mInfomation.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.setJMenuBar(this.menuBar);
        this.st.setLayout(new BorderLayout());
        this.st.add(this.sta);
        MemoryMonitor memoryMonitor = new MemoryMonitor();
        this.st.add((Component)memoryMonitor.getJProgressBar(), "West");
        this.getContentPane().add((Component)this.st, "South");
        this.sta.setText("GTI Builder");
        this.addWindowListener(this);
        StringArray stringArray = new StringArray();
        stringArray.add("FILE", this.mFile);
        stringArray.add("EDIT", this.mEdit);
        stringArray.add("TOOLS", this.mTools);
        stringArray.add("PROJECT", this.mProject);
        stringArray.add("HELP", this.mHelp);
        this.pm.setKeyMenuItems(stringArray);
        this.pm.setJMenuBar(this.menuBar);
        this.pm.addWindow(this);
        this.getContentPane().add("Center", this.pm);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mNew) {
            this.pm.newFile();
        }
        if (object == this.mQuit) {
            this.exit();
        }
        if (object == this.mClose) {
            this.pm.closeProject();
        }
        if (object == this.mFilePreference) {
            this.pm.getProject().showFilePreference();
        }
        if (object == this.mProjectPreference) {
            this.pm.getProject().showProjectPreference();
        }
        if (object == this.mCopy) {
            this.pm.getProject().copy();
        }
        if (object == this.mCut) {
            this.pm.getProject().cut();
        }
        if (object == this.mPaste) {
            this.pm.getProject().paste();
        }
        if (object == this.mDelete) {
            this.pm.getProject().delete();
        }
        if (object == this.mUndo) {
            this.pm.getProject().undo();
        }
        if (object == this.mRedo) {
            this.pm.getProject().redo();
        }
        if (object == this.mSave) {
            this.pm.getProject().save();
        }
        if (object == this.mSaveAs) {
            this.pm.getProject().saveAs();
        }
        if (object == this.mPrint) {
            this.pm.getProject().print();
        }
        if (object == this.mOpen) {
            this.pm.openProject();
        }
        if (object == this.mAddFile) {
            this.pm.getProject().addFile();
        }
        if (object == this.mRemoveFile) {
            this.pm.getProject().removeEditor();
        }
        if (object == this.mPreference) {
            new Preference((Frame)this, true, this.pm).show();
        }
        if (object == this.mRestart) {
            this.restart();
        }
        if (object == this.mInfomation) {
            new Help((Frame)new JFrame(), true).show();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exit();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void setStatus(String string) {
        this.sta.setText(string);
    }

    public void showProgressBar() {
        this.st.add((Component)this.sb, "East");
    }

    public void hideProgressBar() {
        this.st.remove(this.sb);
    }

    public JProgressBar getProgressBar() {
        return this.sb;
    }

    public static MainWindow getMainWindow() {
        return mainFrame;
    }

    public void updataLookAndFeel() {
        this.pm.getWindowManager().updataLookAndFeel();
        SwingUtilities.updateComponentTreeUI(this.sb);
    }

    public void restart() {
        if (this.pm.exit()) {
            this.pm.getWindowManager().restart();
            FileDataBase.clear();
            UserPreferences.getSystemPreferences().saveData();
            UserPreferences.clearSystem();
            TextColoring.reset();
            System.gc();
            Main.main(new String[0]);
        }
    }

    public void exit() {
        if (this.pm.exit()) {
            this.compelToExit();
        }
    }

    public void compelToExit() {
        this.pm.getWindowManager().restart();
        FileDataBase.clear();
        UserPreferences.getSystemPreferences().saveData();
        UserPreferences.clearSystem();
        System.gc();
        System.exit(0);
    }

    public ProjectManager getProjectManager() {
        return this.pm;
    }

    class MemoryMonitor
    implements ActionListener {
        private Timer timer = new Timer(200, this);
        private JProgressBar pb = new JProgressBar();
        int count = 0;

        public MemoryMonitor() {
            this.timer.start();
            this.pb.setStringPainted(true);
            this.pb.setMaximum((int)Runtime.getRuntime().totalMemory() / 1024);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runtime runtime = Runtime.getRuntime();
            this.pb.setMaximum((int)runtime.totalMemory() / 1024);
            this.pb.setValue((int)(runtime.freeMemory() / 1024L));
            this.pb.setString("" + (int)(runtime.freeMemory() / 1024L) + "kB/" + runtime.totalMemory() / 1024L + "kB");
            Thread.yield();
            Thread.yield();
            Thread.yield();
            Thread.yield();
        }

        public JProgressBar getJProgressBar() {
            return this.pb;
        }
    }
}

