/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.plugin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class DynamicZipClassLoader
extends ClassLoader {
    private ZipFile zip;

    public DynamicZipClassLoader(ZipFile zipFile) {
        this.zip = zipFile;
    }

    private byte[] loadClassData(String string) throws ClassNotFoundException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = null;
        try {
            ZipEntry zipEntry = this.zip.getEntry(TextBuffer.replace(string, ".", "/") + ".class");
            if (zipEntry == null) {
                throw new ClassNotFoundException("Class " + string + " is not found or can not read.");
            }
            InputStream inputStream = this.zip.getInputStream(zipEntry);
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Class " + string + " is not found or can not read.");
        }
        return byArray;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findClass(string);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            byte[] byArray = this.loadClassData(string);
            clazz = super.defineClass(string, byArray, 0, byArray.length);
        }
        return clazz;
    }

    protected void finalize() {
        try {
            this.zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

