/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.editor.EditorUpdataManager;
import jp.sourceforge.gtibuilder.editor.HTMLColoring;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.NewPanel;
import jp.sourceforge.gtibuilder.project.EditorUpdataEvent;
import jp.sourceforge.gtibuilder.project.EditorUpdataListener;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class HTMLEditor
implements EditorComponent {
    private String fileName = null;
    private String directory = null;
    private JTextPane tag = new JTextPane();
    private JScrollPane stag = new JScrollPane(this.tag);
    private JTextPane view = new JTextPane();
    private JScrollPane sview = new JScrollPane(this.view);
    private JTabbedPane tabPane = new JTabbedPane();
    private FileType ft = null;
    private UndoManager undo = new UndoManager();
    private HTMLColoring htmlc = new HTMLColoring(this.tag);
    private boolean edited = false;
    private ChangeUpdate cu = new ChangeUpdate();
    private EditorUpdataManager eum = new EditorUpdataManager();

    public void addEditorUpdataListener(EditorUpdataListener editorUpdataListener) {
        this.eum.addEditorUpdataListener(editorUpdataListener);
    }

    public void compiled() {
    }

    public void copy() {
        this.tag.copy();
    }

    public void cut() {
        this.tag.cut();
    }

    public void delete() {
    }

    public Component getComponent() {
        return this.tabPane;
    }

    public byte[] getData() {
        String string = this.tag.getText();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorDialog.showError(unsupportedEncodingException);
            return null;
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Dialog getFilePreference() {
        return null;
    }

    public FileType getFileType() {
        return this.ft;
    }

    public NewPanel getNewFilePropertyPane() {
        return null;
    }

    public Component getPrintComponent() {
        return this.view;
    }

    public FileType[] getSupportedTypes() {
        boolean bl;
        FileType fileType = FileDataBase.getWithExtension("txt");
        int n = 0;
        FileType fileType2 = FileDataBase.getWithMime("text/html");
        boolean bl2 = bl = fileType2 != fileType;
        if (bl) {
            ++n;
        }
        int n2 = 0;
        FileType[] fileTypeArray = new FileType[n];
        if (bl) {
            fileTypeArray[n2] = fileType2;
            ++n2;
        }
        return fileTypeArray;
    }

    public void init(StringArray stringArray, FileType fileType) {
        this.view.setEditable(false);
        this.tabPane.add((Component)this.stag, "TAG EDIT");
        this.tabPane.add((Component)this.sview, "HTML VIEW");
        this.view.setContentType("text/html");
        this.tag.getDocument().addDocumentListener(this.cu);
        this.tag.getDocument().addUndoableEditListener(this.cu);
        this.tabPane.getModel().addChangeListener(this.cu);
        this.setFileType(fileType);
        this.setFileName((String)stringArray.getContent("NAME"));
        this.setDirectory((String)stringArray.getContent("DIRECTORY"));
    }

    public boolean isAutoCheckProperty() {
        return false;
    }

    public boolean isCompiled() {
        return false;
    }

    public boolean isEdited() {
        return this.edited;
    }

    public boolean isSupportedType(FileType fileType) {
        return fileType.getMimeType().equals("text/html");
    }

    public void paste() {
        this.tag.paste();
    }

    public boolean readData(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8");
            this.tag.setText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorDialog.showError(unsupportedEncodingException);
            return false;
        }
        this.edited = false;
        this.undo.die();
        return true;
    }

    public void redo() {
        if (this.undo.canRedo()) {
            this.undo.redo();
        }
    }

    public void removeEditorUpdataListener(EditorUpdataListener editorUpdataListener) {
        this.eum.removeEditorUpdataListener(editorUpdataListener);
    }

    public void saved() {
        this.edited = false;
    }

    public boolean setDirectory(String string) {
        this.directory = string;
        this.eum.updataEditor(new EditorUpdataEvent(this, this.fileName, this.directory));
        return true;
    }

    public boolean setFileName(String string) {
        this.fileName = string;
        this.eum.updataEditor(new EditorUpdataEvent(this, this.fileName, this.directory));
        return true;
    }

    public boolean setFileType(FileType fileType) {
        this.ft = fileType;
        return true;
    }

    public void undo() {
        if (this.undo.canUndo()) {
            this.undo.undo();
        }
    }

    public boolean usingEditMenu() {
        return true;
    }

    public JMenu[] usingMenu() {
        return null;
    }

    private class ChangeUpdate
    implements DocumentListener,
    UndoableEditListener,
    ChangeListener {
        private ChangeUpdate() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            HTMLEditor.this.edited = true;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            HTMLEditor.this.edited = true;
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (undoableEditEvent.toString().indexOf(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/main/Bundle").getString("Editor.style")) != -1) {
                HTMLEditor.this.undo.addEdit(undoableEditEvent.getEdit());
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (HTMLEditor.this.tabPane.getSelectedIndex() != 1) {
                return;
            }
            String string = HTMLEditor.this.tag.getText();
            int n = string.indexOf("<meta");
            while (n != -1) {
                int n2 = string.indexOf(">", n);
                string = TextBuffer.replace(string, n, n2, "");
                n = string.indexOf("<meta", n);
            }
            HTMLEditor.this.view.setText(string);
        }
    }
}

