//  endian.hpp: little/big endian codec

//  Copyright Takeshi Mouri 2006.
//  Use, modification, and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef HAMIGAKI_AUDIO_DETAIL_ENDIAN_HPP
#define HAMIGAKI_AUDIO_DETAIL_ENDIAN_HPP

#include <boost/cstdint.hpp>

namespace hamigaki { namespace audio { namespace detail {

inline boost::uint16_t char_to_uint16(char c)
{
    return static_cast<boost::uint16_t>(static_cast<unsigned char>(c));
}

inline boost::uint16_t decode_little_endian16(const char* s)
{
    return
        (char_to_uint16(s[0])     ) |
        (char_to_uint16(s[1]) << 8) ;
}

inline boost::uint32_t char_to_uint32(char c)
{
    return static_cast<boost::uint32_t>(static_cast<unsigned char>(c));
}

inline boost::uint32_t decode_little_endian32(const char* s)
{
    return
        (char_to_uint32(s[0])      ) |
        (char_to_uint32(s[1]) <<  8) |
        (char_to_uint32(s[2]) << 16) |
        (char_to_uint32(s[3]) << 24) ;
}

inline void encode_little_endian16(char* s, boost::uint16_t n)
{
    s[0] = static_cast<char>(static_cast<unsigned char>((n     ) & 0xFF));
    s[1] = static_cast<char>(static_cast<unsigned char>((n >> 8) & 0xFF));
}

inline void encode_little_endian32(char* s, boost::uint32_t n)
{
    s[0] = static_cast<char>(static_cast<unsigned char>((n      ) & 0xFF));
    s[1] = static_cast<char>(static_cast<unsigned char>((n >>  8) & 0xFF));
    s[2] = static_cast<char>(static_cast<unsigned char>((n >> 16) & 0xFF));
    s[3] = static_cast<char>(static_cast<unsigned char>((n >> 24) & 0xFF));
}

} } } // End namespaces detail, audio, hamigaki.

#endif // HAMIGAKI_AUDIO_DETAIL_ENDIAN_HPP
