#include "main.h"
#include <stdio.h>
#include <string.h>
int imgin[90];

void fileInit(int cyls)
{
	int i;
	for (i = 0; i < 90; i++) {
		imgin[i] = 0;
	}
	for (i = 0; i < cyls * 2 * 18; i++) {
		imgin[i / 32] |= 1 << (i % 32);
	}
	return;
}

void fatRead(int *fat)
{
	unsigned char *img = (unsigned char *) (DISK_ADDR + 0x000200);
	int i, j = 0;
	for (i = 0; i < 2880; i += 2) {
		fat[i] = (img[j] | img[j + 1] << 8) & 0x0fff;
		fat[i + 1] = (img[j + 1] >> 4 | img[j + 2] << 4) & 0x0fff;
		j += 3;
	}
	return;
}

void fatWrite(int *fat)
{
	unsigned char *img = (unsigned char *) (DISK_ADDR + 0x000200);
	unsigned char *img1 = (unsigned char *) (DISK_ADDR + 0x001400), im[3];
	int i, j = 0;
	for (i = 0; i < 2880; i += 2) {
		im[0] = fat[i] & 0xff;
		im[1] = ((fat[i] >> 8) & 0xff) | ((fat[i + 1] << 4) & 0xf0);
		im[2] = (fat[i + 1] >> 4) & 0xff;
		if (im[0] != img[j] || im[1] != img[j + 1] || im[2] != img[j + 2]) {
			img[j] = im[0];
			img[j + 1] = im[1];
			img[j + 2] = im[2];
			fdcReq(2, ((int) &img[j] - DISK_ADDR) / 512, 1);
		} else if (im[0] != img1[j] || im[1] != img1[j + 1] || im[2] != img1[j + 2]) {
			img1[j] = im[0];
			img1[j + 1] = im[1];
			img1[j + 2] = im[2];
			fdcReq(2, ((int) &img1[j] - DISK_ADDR) / 512, 1);
		}
		j += 3;
	}
	return;
}

struct file *fileSearch(unsigned char *name)
{
	struct file *file = (struct file *) (DISK_ADDR + 0x00002600);
	int i, j;
	unsigned char s[12];
	for (i = 0; i < 11; i++) {
		s[i] = ' ';
	}
	i = 0;
	for (j = 0; name[j] != 0; j++) {
		if (i >= 11) {
			return 0;
		}
		if (name[j] == '.' && j <= 8) {
			i = 8;
		} else {
			s[i] = name[j];
			if ('a' <= s[i] && s[i] <= 'z') {
				s[i] -= 0x20;
			}
			i++;
		}
	}
	for (i = 0; i < 224;) {
		if (file[i].name[0] == 0x00) {
			break;
		}
		if ((file[i].type & 0x18) == 0) {
			for (j = 0; j < 11; j++) {
				if (file[i].name[j] != s[j]) {
					goto next;
				}
			}
			return file + i;
		}
next:
		i++;
	}
	return 0;
}

void bufSet(struct fhandle *fh, int addr)
{
	struct task *task = taskNow();
	unsigned char *img = (unsigned char *) (DISK_ADDR + 0x003e00);
	int i, j, a0 = 0, sect;
	bufFlush(fh);
	for (i = fh->file->cno; ;) {
		if ((int) (fh->size / 512) * 512 <= a0 && i >= 0x0ff8) {
			i = bufAdd(fh);
			break;
		}
		if (addr < 512) {
			break;
		}
		addr -= 512;
		a0 += 512;
		i = task->fat[i];
	}
	sect = i + 0x003e00 / 512;
	if ((imgin[sect / 32] & (1 << (sect % 32))) == 0) {
		fdcReq(1, sect, 1);
		imgin[sect / 32] |= 1 << (sect % 32);
	}
	for (j = 0; j < 512; j++) {
		fh->buf[j] = img[i * 512 + j];
	}
	fh->bcaddr = i;
	fh->baddr = a0;
	return;
}

int bufAdd(struct fhandle *fh)
{
	struct task *task = taskNow();
	unsigned char *img = (unsigned char *) (DISK_ADDR + 0x003e00);
	int i, j;
	for (i = fh->file->cno; task->fat[i] < 0x0ff8; i = task->fat[i]) { }
	j = fatGet(task->fat);
	task->fat[i] = j;
	task->fat[j] = 0x0fff;
	for (i = 0; i < 512; i++) {
		img[j * 512 + i] = 0;
	}
	fdcReq(2, ((int) &img[j * 512] - DISK_ADDR) / 512, 1);
	fatWrite(task->fat);
	return j;
}

void bufFlush(struct fhandle *fh)
{
	unsigned char *img = (unsigned char *) (DISK_ADDR + 0x003e00);
	int i;
	if (fh->mode != 1) {
		return;
	}
	for (i = 0; i < 512; i++) {
		img[fh->bcaddr * 512 + i] = fh->buf[i];
	}
	fh->mode = 0;
	fileSetdate(fh->file);
	fdcReq(2, ((int) &img[fh->bcaddr * 512] - DISK_ADDR) / 512, 1);
	fdcReq(2, ((int) fh->file - DISK_ADDR) / 512, 1);
	return;
}

struct file *fileCreate(int *fat, unsigned char *name)
{
	struct file *file, *t;
	if (name[0] == 0) {
		return 0;
	}
	file = fileGetlist();
	if (file != 0) {
		t = fileSearch(name);
		if (t == 0) {
			fileSetname(file, name);
			fileSetdate(file);
			file->size = 0;
			file->type = 0x20;
			file->cno = fatGet(fat);
			fat[file->cno] = 0x0fff;
			fatWrite(fat);
			fdcReq(2, ((int) file - DISK_ADDR) / 512, 1);
			return file;
		}
	}
	return 0;
}

void fileDelete(int *fat, struct file *file)
{
	int i, j;
	file->name[0] = 0xe5;
	file->size = 0;
	file->type = 0;
	fdcReq(2, ((int) file - DISK_ADDR) / 512, 1);
	for (i = file->cno; fat[i] < 0x0ff8; ) {
		j = fat[i];
		fat[i] = 0;
		i = j;
	}
	fat[i] = 0;
	fatWrite(fat);
	return;
}

int fileRename(struct file *file, unsigned char *name)
{
	struct file *t = fileSearch(name);
	if (t == 0) {
		fileSetname(file, name);
		fileSetdate(file);
		fdcReq(2, ((int) file - DISK_ADDR) / 512, 1);
		return 1;
	}
	return 0;
}

unsigned char *fileRead(int *fat, int cno, int size)
{
	unsigned char *img = (unsigned char *) (DISK_ADDR + 0x003e00);
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	unsigned char *buf, *buf2;
	int sect, i = cno, j = size, start = -1, n = -1, head = -1, cyl = -1;
	buf = (unsigned char *) memAlloc(mem, size);
	buf2 = buf;
	for (;;) {
		sect = i + 0x003e00 / 512;
		if ((imgin[sect / 32] & (1 << (sect % 32))) == 0) {
			if (start == -1) {
restart:
				start = sect;
				head = sect % 36 / 18;
				cyl = sect / 36;
				n = 1;
			} else if (head == sect % 36 / 18 && cyl == sect / 36) {
				n++;
			} else {
				fdcReq(1, start, n);
				goto restart;
			}
			imgin[sect / 32] |= 1 << (sect % 32);
		}
		if (j <= 512) {
			if (start != -1) {
				fdcReq(1, start, n);
			}
			break;
		}
		j -= 512;
		i = fat[i];
	}
	for (;;) {
		if (size <= 512) {
			for (i = 0; i < size; i++) {
				buf[i] = img[cno * 512 + i];
			}
			return buf2;
		}
		for (i = 0; i < 512; i++) {
			buf[i] = img[cno * 512 + i];
		}
		size -= 512;
		buf += 512;
		cno = fat[cno];
	}
}

unsigned char *fileReadTek(int *fat, int cno, int *psize)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	unsigned char *buf, *buf2;
	int size = *psize, size2;
	buf = fileRead(fat, cno, size);
	if (size >= 17) {
		size2 = tek_getsize(buf);
		if (size2 > 0) {
			buf2 = (unsigned char *) memAlloc(mem, size2);
			tek_decomp(buf, buf2, size2);
			memFree(mem, (int) buf, size);
			buf = buf2;
			*psize = size2;
		}
	}
	return buf;
}

unsigned short fatGet(int *fat)
{
	int i;
	for (i = 0; i < 2880; i++) {
		if (fat[i] == 0) {
			return i;
		}
	}
	return 0;
}

struct file *fileGetlist(void)
{
	struct file *file = (struct file *) (DISK_ADDR + 0x00002600);
	int i;
	for (i = 0; i < 224; i++) {
		if (file[i].type == 0x00 || file[i].name[0] == 0xe5) {
			return &file[i];
		}
	}
	return 0;
}

void fileSetname(struct file *file, unsigned char *name)
{
	int i, j;
	unsigned char s[12];
	for (i = 0; i < 11; i++) {
		s[i] = ' ';
	}
	i = 0;
	for (j = 0; name[j] != 0; j++) {
		if (i >= 11) {
			return;
		}
		if (name[j] == '.' && j <= 8) {
			i = 8;
		} else {
			s[i] = name[j];
			if ('a' <= s[i] && s[i] <= 'z') {
				s[i] -= 0x20;
			}
			i++;
		}
	}
	for (i = 0; i < 11; i++) {
		file->name[i] = s[i];
	}
	return;
}

void fileSetdate(struct file *file)
{
	struct clock t;
	unsigned short time, date;
	clockGet(&t);
	time = 2048 * (t.hour - 9) + 32 * t.min + t.sec / 2;
	date = 512 * (t.year - 1980) + 32 * t.month + t.day;
	file->time = time;
	file->date = date;
	return;
}

void fileGetdate(struct file *file, struct clock *clock)
{
	clock->year = file->date / 512 + 1980;
	clock->month = file->date % 512 / 32;
	clock->day = file->date % 512 % 32;
	clock->hour = file->time / 2048;
	clock->min = file->time % 2048 / 32;
	clock->sec = file->time % 2048 % 32 * 2;
	return;
}

void filerTask(struct sheet *sht)
{
	struct file *file = (struct file *) (DISK_ADDR + 0x00002600);
	struct task *task = taskNow();
	struct filer filer;
	struct timer *timer, *timer2;
	int i, j;
	filer.sht = sht;
	filer.now = -1;
	filer.start = 0;
	filer.dc = -1;
	filer.act = 1;
	filerPrint(&filer);
	timer = timerAlloc();
	timerInit(timer, &task->fifo);
	timerSet(timer, 300, 2);
	timer2 = timerAlloc();
	timerInit(timer2, &task->fifo);

	for (;;) {
		cli();
		if (fifoStat(&task->fifo) == 0) {
			taskSleep(task);
			sti();
		} else {
			i = fifoGet(&task->fifo);
			sti();
			if (i == 1) {
				timerCancel(timer);
				timerCancel(timer2);
				cli();
				filerExitreq(sht);
				sti();
				for (;;) {
					taskSleep(task);
				}
			} else if (i == 2) {
				filer.act = 1;
			} else if (i == 3) {
				filer.act = 0;
			} else if (i == 4) {
				timerSet(timer, 300, 4);
			} else if (i == 5) {
				filer.start--;
				if (filer.start < 0) {
					filer.start = 0;
				}
				filer.dc = -1;
				timerCancel(timer);
				timerSet(timer, 300, 4);
			} else if (i == 6) {
				filer.start++;
				j = 0;
				for (i = 0; i < 224; i++) {
					if (file[i].name[0] == 0x00) {
						break;
					}
					if (file[i].name[0] != 0xe5) {
						if ((file[i].type & 0x18) == 0) {
							j++;
						}
					}
				}
				if (filer.start > j - 8) {
					filer.start = j - 8;
					if (filer.start < 0) {
						filer.start = 0;
					}
				}
				filer.dc = -1;
				timerCancel(timer);
				timerSet(timer, 300, 4);
			} else if (i == 7) {
				filer.dc = -1;
			} else if (i >= 512) {
				filer.now = i - 512 + filer.start;
				if (filer.now == filer.dc) {
					filerRun(&filer);
					filer.now = -1;
					filer.dc = -1;
					timerCancel(timer2);
				} else {
					filer.dc = filer.now;
					timerCancel(timer2);
					timerSet(timer2, 50, 7);
				}
				timerCancel(timer);
				timerSet(timer, 300, 4);
			}
			filerPrint(&filer);
		}
	}
}

struct sheet *filerOpen(int *fat)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct sheet *sht = shtAlloc();
	unsigned char *buf = (unsigned char *) memAlloc(mem, 128 * 165);
	struct task *task = taskAlloc("filer");
	int *fifo = (int *) memAlloc(mem, 128 * 4);
	shtSet(sht, buf, 128, 165, -1);
	winAlloc(sht, "t@C", 0);
	textbox(sht, _FFFFFF, 8, 28, 112, 128);
	task->stack = memAlloc(mem, 64 * 1024);
	task->tss.esp = task->stack + 64 * 1024 - 8;
	task->tss.eip = (int) &filerTask;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;
	*((int *) (task->tss.esp + 4)) = (int) sht;
	fifoInit(&task->fifo, fifo, 128, task);
	task->fat = fat;
	taskRun(task, 2, 2);
	sht->task = task;
	sht->flag |= SHEET_FILER | SHEET_CUR;
	return sht;
}

void filerClose(struct sheet *sht)
{
	extern struct tasks *tctl;
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct task *task = sht->task;
	memFree(mem, (int) sht->buf, 128 * 165);
	shtFree(sht);
	taskSleep(task);
	memFree(mem, task->stack, 64 * 1024);
	memFree(mem, (int) task->fifo.buf, 128 * 4);
	cli();
	task->flag = 0;
	if (tctl->tfpu == task) {
		tctl->tfpu = 0;
	}
	task->name[0] = 'A';
	sti();
	return;
}

void filerExitreq(struct sheet *sht)
{
	extern struct sheets *shts;
	struct fifo *fifo = (struct fifo *) *((int *) FIFO_ADDR);
	fifoPut(fifo, 2280 + (sht - shts->sheet));
	return;
}

void filerPrint(struct filer *filer)
{
	struct file *file = (struct file *) (DISK_ADDR + 0x00002600);
	int i, j = 0, k = 0, l;
restart:
	for (i = 0; i < 8; i++) {
		filer->file[i] = 0;
	}
	for (i = 0; i < 224; i++) {
		if (file[i].name[0] == 0x00) {
			break;
		}
		if (file[i].name[0] != 0xe5) {
			if ((file[i].type & 0x18) == 0) {
				if (j == filer->start) {
					break;
				}
				j++;
			}
		}
	}
	for (j = 0; i < 224; i++) {
		if (file[i].name[0] == 0x00) {
			break;
		}
		if (file[i].name[0] != 0xe5) {
			if ((file[i].type & 0x18) == 0) {
				filer->file[j] = &file[i];
				j++;
				if (j >= 8) {
					break;
				}
			}
		}
	}
	for (i = 0; i < 224; i++) {
		if (file[i].name[0] == 0x00) {
			break;
		}
		if (file[i].name[0] != 0xe5) {
			if ((file[i].type & 0x18) == 0) {
				k++;
			}
		}
	}
	if (filer->file[7] == 0) {
		filer->start--;
		if (filer->start < 0) {
			filer->start = 0;
			goto next;
		}
		filer->dc = -1;
		goto restart;
	}
next:
	filerPlist(filer);
	graphicBox(filer->sht, _C6C6C6, filer->sht->sx - 21, 27, filer->sht->sx - 8, filer->sht->sy - 9);
	graphicButton(filer->sht, filer->sht->sx - 20, 27, 12, 20, "\36", 0);
	graphicButton(filer->sht, filer->sht->sx - 20, filer->sht->sy - 29, 12, 20, "\37", 0);
	l = (filer->sht->sy - 48 - 30) * j / k;
	if (k <= 8) {
		i = 48;
	} else {
		i = 48 + (filer->sht->sy - 48 - 29 - l) / (k - j) * filer->start;
	}
	graphicButton(filer->sht, filer->sht->sx - 20, i, 12, l - 1, "", 0);
	shtRefresh(filer->sht, 8, 27, 121, 157);
	return;
}

void filerPlist(struct filer *filer)
{
	char s[13];
	int i, j;
	s[12] = 0;
	for (i = 0; i < 8; i++) {
		graphicBox(filer->sht, _FFFFFF, 8, 28 + i * 16, filer->sht->sx - 23, 28 + i * 16 + 16);
		if (filer->file[i] == 0) {
			break;
		}
		for (j = 0; j < 8; j++) {
			s[j] = filer->file[i]->name[j];
		}
		s[9] = filer->file[i]->ext[0];
		s[10] = filer->file[i]->ext[1];
		s[11] = filer->file[i]->ext[2];
		if (filer->file[i]->ext[0] == ' ') {
			s[8] = ' ';
		} else {
			s[8] = '.';
		}
		if (filer->now - filer->start == i && filer->act != 0) {
			graphicBox(filer->sht, _000084, 8, 28 + i * 16, filer->sht->sx - 23, 28 + i * 16 + 16);
			graphicPuts(filer->sht, _FFFFFF, 8, 28 + i * 16, s);
		} else {
			graphicBox(filer->sht, _FFFFFF, 8, 28 + i * 16, filer->sht->sx - 23, 28 + i * 16 + 16);
			graphicPuts(filer->sht, _000000, 8, 28 + i * 16, s);
		}
	}
	return;
}

void filerRun(struct filer *filer)
{
	static char *bind[7 * 2] = {
		"HRB", "%s",
		"BMP", "iview %s",
		"JPG", "iview %s",
		"MML", "mplay %s",
		"TXT", "memo %s",
		"C  ", "memo %s",
		"H  ", "memo %s"
	};
	struct task *task = taskNow();
	char s[31], name[13];
	int i, j;
	for (i = 0; i < 31; i++) {
		s[i] = 0;
	}
	filerMakename(filer, name);
	for (j = 0; name[j] != 0; j++) {
		if (name[j] == '.') {
			break;
		}
	}
	for (i = 0; i < 7; i++) {
		if (strncmp(bind[i * 2], name + j + 1, 3) == 0) {
			sprintf(s, bind[i * 2 + 1], name);
			break;
		}
	}
	if (i == 7) {
		sprintf(s, "bedit %s", name);
	}
	consNcst(s, task->fat);
	return;
}

void filerMakename(struct filer *filer, char *name)
{
	struct file *file = filer->file[filer->now - filer->start];
	int i, j = 0;
	for (i = 0; i < 13; i++) {
		name[i] = 0;
	}
	for (i = 0; i < 12; i++) {
		if (&file->name[i] == &file->ext[0] && 0 < j && name[j - 1] != '.') {
			name[j] = '.';
			j++;
			i--;
		} else if (file->name[i] != ' ') {
			name[j] = file->name[i];
			j++;
		}
	}
	return;
}
