#include "main.h"
#include <string.h>
struct tbar *tbar;

void tbarInit(struct sheet *sht)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
 	struct binfo *binfo = (struct binfo *) BINFO_ADDR;
	int i;
	tbar = (struct tbar *) memAlloc(mem, sizeof(struct tbar));
	for (i = 0; i < SHEETS; i++) {
		tbar->win[i].sht = 0;
	}
	tbar->cont = 0;
	tbar->select = -1;
	tbar->start = 0;
	tbar->each = (binfo->scrnx - 123) / 136;
	tbar->sht = sht;
	menuBoff(sht);
	return;
}

void tbarAdd(struct sheet *sht, unsigned char *title)
{
	int i;
	for (i = 0; i < SHEETS; i++) {
		if (tbar->win[i].sht == 0) {
			tbar->win[i].sht = sht;
			strncpy(tbar->win[i].title, title, 30);
			tbar->cont++;
			break;
		}
	}
	tbar->start = (i / tbar->each) * tbar->each;
	tbarPrint();
	return;
}

void tbarRemove(struct sheet *sht)
{
	int i;
	for (i = 0; i < SHEETS; i++) {
		if (tbar->win[i].sht == sht) {
			tbar->win[i].sht = 0;
			tbar->cont--;
			break;
		}
	}
	if (i == SHEETS) {
		return;
	}
	if (tbar->start >= tbar->cont) {
		tbar->start = (tbar->start / tbar->each) - 1;
	}
	if (tbar->start < 0) {
		tbar->start = 0;
	}
	for (; i < SHEETS; i++) {
		tbar->win[i] = tbar->win[i + 1];
	}
	tbarPrint();
	return;
}

void tbarSelect(struct sheet *sht)
{
	int i;

	for (i = 0; i < SHEETS; i++) {
		if (tbar->win[i].sht == sht) {
			tbar->select = i;
			tbar->start = tbar->select / tbar->each * tbar->each;
			break;
		}
	}
	tbarPrint();
	return;
}

void tbarUnselect(void)
{
	tbar->select = -1;
	tbarPrint();
	return;
}

void tbarRun(int h, int x, int y)
{
	struct window *win;
	int i;
	if (h == 0 && tbar->sht->sy - 24 <= y && y <= tbar->sht->sy - 2) {
		if (tbar->sht->sx - 61 <= x && x <= tbar->sht->sx - 50) {
			if (tbar->cont > tbar->each) {
				tbar->start += tbar->each;
				if (tbar->start >= tbar->cont) {
					tbar->start = 0;
				}
			}
		} else if (62 <= x && x <= tbar->sht->sx - 63) {
			i = (x - 62) / 134;
			if (0 <= i && i < tbar->each) {
				win = &tbar->win[tbar->start + i];
				shtTupdown(win->sht);
				winRefresh();
			}
		}
	}
	tbarPrint();
	return;
}

void tbarPrint(void)
{
	struct window *win;
	int i;
	graphicBox(tbar->sht, _C6C6C6, 64, tbar->sht->sy - 24, tbar->sht->sx - 50, tbar->sht->sy - 2);
	for (i = 0; i < tbar->each; i++) {
		win = &tbar->win[tbar->start + i];
		if (win->sht == 0) {
			break;
		}
		tbarPrint0(win, i);
	}
	if (tbar->cont > tbar->each) {
		graphicButton(tbar->sht, tbar->sht->sx - 63, tbar->sht->sy - 24, 13, 21, "\20", 0);
	}
	shtRefresh(tbar->sht, 58, tbar->sht->sy - 24, tbar->sht->sx - 49, tbar->sht->sy - 1);
	return;
}

void tbarPrint0(struct window *win, int i)
{
	int x = 64 + (i * 136);
	if (tbar->start + i == tbar->select) {
		graphicButton(tbar->sht, x, tbar->sht->sy - 24, 134, 21, win->title, 1);
	} else {
		graphicButton(tbar->sht, x, tbar->sht->sy - 24, 134, 21, win->title, 0);
	}
	return;
}

void menuInit(struct menu *menu, unsigned char *title)
{
	int i;
	menu->sht = 0;
	menu->csht = 0;
	menu->title = title;
	menu->mode = 0;
	menu->now = 0;
	for (i = 0; i < SELECTS; i++) {
		menu->sel[i].mode = 0;
	}
	return;
}

void menuAdd(struct menu *menu, unsigned char *name, unsigned char *line, struct menu *m)
{
	struct select *s;
	int i;
	for (i = 0; i < SELECTS; i++) {
		if (menu->sel[i].mode == 0) {
			s = &menu->sel[i];
			if (m == 0) {
				s->name = name;
				s->line = line;
				s->mode = SEL_SELECT;
				s->menu = 0;
			} else {
				s->name = name;
				s->menu = m;
				s->line = 0;
				s->mode = SEL_SUBMENU;
			}
			return;
		}
	}
	return;
}

void menuRun(struct sheet *sht, struct menu *m, int mx, int my, int h)
{
	struct menu *msub;
	struct sheet *ms;
	int i;
	if (h == 0 && 2 <= mx && mx <= 60 && sht->sy - 24 <= my && my <= sht->sy - 3) {
		if (m->mode == 0) {
			m->mode = MENU_ACCTIVE;
			menuBon(sht);
			if (m->sht == 0) {
				m->sht = menuSheet(m);
			}
			if (m->now != 0) {
				m->now = 0;
				menuRefresh(m, m->sht);
			}
			ms = m->sht;
			shtMupdown(ms);
			shtSlide(ms, 0, sht->sy - ms->sy - 28);
		} else {
			goto off;
		}
	} else {
		msub = shtMchk(h);
		if (msub != 0) {
			if (msub->csht != 0) {
				if ((msub->csht->flag & SHEET_MENU) != 0) {
					msub->csht->menu->mode = 0;
					shtUpdown(msub->csht, -1);
				}
				msub->csht = 0;
			}
		}
		if (msub != 0) {
			i = menuCheck(msub, mx - msub->sht->x, my - msub->sht->y);
			if (i != 0) {
				goto off;
			}
		} else if (m->mode == MENU_ACCTIVE) {
off:
			m->mode = 0;
			menuBoff(sht);
			shtMclose();
		}
	}
	return;
}

void menuBon(struct sheet *sht)
{
	graphicButton(sht, 2, sht->sy - 24, 60, 21, "TeaseOS", 1);
	shtRefresh(sht, 2, sht->sy - 24, 63, sht->sy - 2);
	return;
}

void menuBoff(struct sheet *sht)
{
	graphicButton(sht, 2, sht->sy - 24, 60, 21, "TeaseOS", 0);
	shtRefresh(sht, 2, sht->sy - 24, 63, sht->sy - 2);
	return;
}

struct sheet *menuSheet(struct menu *menu)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct sheet *sht = shtAlloc();
	unsigned char *sbuf;
	int sx = 8, sy = 8, i, j;
	sht->flag |= SHEET_MENU;
	if (menu->title != 0) {
		sy += 20;
		sx = 8 + 8 * strlen(menu->title);
	}
	for (i = 0; menu->sel[i].mode != 0 && i < SELECTS; i++) {
		j = 8 + 8 * strlen(menu->sel[i].name);
		if (menu->sel[i].menu != 0) {
			j += 16;
		}
		if (sx < j) {
			sx = j;
		}
		sy += 20;
	}
	sbuf = (unsigned char *) memAlloc(mem, sx * sy);
	shtSet(sht, sbuf, sx, sy, -1);
	sht->menu = menu;
	menuRefresh(menu, sht);
	return sht;
}

void menuRefresh(struct menu *menu, struct sheet *sht)
{
	unsigned char bc, c;
	int sx = sht->sx, sy = sht->sy, y = 4, i;
	graphicBox(sht, _C6C6C6,      0,      0, sx - 1,      0);
	graphicBox(sht, _FFFFFF,      1,      1, sx - 2,      1);
	graphicBox(sht, _C6C6C6,      0,      0,      0, sy - 1);
	graphicBox(sht, _FFFFFF,      1,      1,      1, sy - 2);
	graphicBox(sht, _848484, sx - 2,      1, sx - 2, sy - 2);
	graphicBox(sht, _000000, sx - 1,      0, sx - 1, sy - 1);
	graphicBox(sht, _C6C6C6,      2,      2, sx - 3, sy - 3);
	graphicBox(sht, _848484,      1, sy - 2, sx - 2, sy - 2);
	graphicBox(sht, _000000,      0, sy - 1, sx - 1, sy - 1);
	if (menu->title != 0) {
		graphicBox(sht, _000084, 2, 2, sx - 4, 20);
		graphicPuts(sht, _FFFFFF, 3, 3, menu->title);
		y = 24;
	}
	for (i = 0; menu->sel[i].mode != 0 && i < SELECTS; i++) {
		if (menu->sel[i].line == 0 && menu->sel[i].menu == 0) {
			c = _848484;
			bc = _C6C6C6;
			graphicBox(sht, bc, 4, y, sht->sx - 4, y + 18);
		} else {
			if (&menu->sel[i] == menu->now) {
				bc = _000084;
				c = _FFFFFF;
			} else {
				bc = _C6C6C6;
				c = _000000;
			}
			graphicBox(sht, bc, 4, y, sht->sx - 4, y + 18);
			if (menu->sel[i].menu != 0) {
				graphicPuts(sht, c, sx - 12, y, "\20");
			}
		}
		graphicPuts(sht, c, 4, y, menu->sel[i].name);
		y += 20;
	}
	shtRefresh(sht, 0, 0, sht->sx, sht->sy);
	return;
}

int menuCheck(struct menu *menu, int x, int y)
{
	struct sheet *sht = menu->sht;
	int i = 0;
	if (2 <= x && x <= sht->sx - 2) {
		if (menu->title != 0) {
			i = (y - 24) / 20;
		} else {
			i = (y - 4) / 20;
		}
		i = menuSelrun(menu, i);
	}
	return i;
}

int menuSelrun(struct menu *menu, int i)
{
	struct task *task = taskNow();
	struct select *sel = &menu->sel[i];
	struct menu *mchild = sel->menu;
	struct sheet *ms = menu->sht, *cms, *sht;
	unsigned char *line = sel->line;
	if (mchild != 0) {
		if (mchild->mode == 0) {
			mchild->mode = MENU_ACCTIVE;
			if (mchild->sht == 0) {
				mchild->sht = menuSheet(mchild);
			}
			if (mchild->now != 0) {
				mchild->now = 0;
				menuRefresh(mchild, mchild->sht);
			}
			cms = mchild->sht;
			shtMupdown(cms);
			if (menu->title != 0) {
				shtSlide(cms, ms->x + ms->sx, ms->y + 20 + (i + 1) * 20 - cms->sy + 4);
			} else {
				shtSlide(cms, ms->x + ms->sx, ms->y + (i + 1) * 20 - cms->sy + 4);
			}
			menu->csht = cms;
		}
	} else {
		if (line[0] == '\1') {
			sht = consOpen(task->fat);
			shtApp(sht);
			winRefresh();
		} else if (line[0] == '\2') {
			reset();
		} else if (line[0] == '\3') {
			sht = filerOpen(task->fat);
			shtApp(sht);
			winRefresh();
		} else if (line[0] == '\4') {
			sht = tmgrOpen(task->fat);
			shtApp(sht);
			winRefresh();
		} else {
			consNcst(line, task->fat);
		}
		shtMclose();
		return 1;
	}
	return 0;
}

void menuLight(struct menu *menu, int mx, int my)
{
	extern struct sheets *shts;
	struct sheet *sht;
	struct menu *m;
	int i, x, y;
	for (i = shts->top - 1; i > 0; i--) {
		sht = shts->sht[i];
		x = mx - sht->x;
		y = my - sht->y;
		if (0 <= x && x < sht->sx && 0 <= y && y < sht->sy) {
			if ((sht->flag & SHEET_MENU) != 0) {
				m = sht->menu;
				if (m->title != 0) {
					m->now = &m->sel[(y - 20 - 4) / 20];
				} else {
					m->now = &m->sel[(y - 4) / 20];
				}
				menuRefresh(m, m->sht);
				return;
			}
		}
	}
	return;
}
