/*
 * Decompiled with CFR 0.152.
 */
package hayashi.yuu.tools.logger;

import hayashi.yuu.tools.logger.YuuLogFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public abstract class LoggerFactory {
    protected static final String LOGGING_PROPERTIES = "log.properties";

    public static void main(String[] args) {
        try {
            Logger logger = LoggerFactory.getInstance();
            logger.finest("[finest] \u8a73\u7d30\u30ec\u30d9\u30eb\uff08\u9ad8\uff09");
            logger.finer("[finer] \u8a73\u7d30\u30ec\u30d9\u30eb\uff08\u4e2d\uff09");
            logger.fine("[fine] \u8a73\u7d30\u30ec\u30d9\u30eb\uff08\u5c0f\uff09");
            logger.config("[config] \u8a2d\u5b9a");
            logger.info("[info] \u60c5\u5831");
            logger.warning("[warning] \u8b66\u544a");
            logger.severe("[severe] \u81f4\u547d\u7684");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Logger getInstance() {
        Logger logger = Logger.getLogger("log");
        logger.fine("\u30ed\u30b0\u8a2d\u5b9a: log.properties\u3092\u3082\u3068\u306b\u30ed\u30b0\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        InputStream inStream = YuuLogFormatter.class.getClassLoader().getResourceAsStream(LOGGING_PROPERTIES);
        if (inStream == null) {
            logger.info("\u30ed\u30b0\u8a2d\u5b9a: log.properties\u306f\u30af\u30e9\u30b9\u30d1\u30b9\u306b\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        } else {
            try {
                LogManager.getLogManager().readConfiguration(inStream);
                logger.config("\u30ed\u30b0\u8a2d\u5b9a: LogManager\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002");
            }
            catch (IOException e) {
                logger.warning("\u30ed\u30b0\u8a2d\u5b9a: LogManager\u8a2d\u5b9a\u306e\u969b\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.toString());
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException e) {
                    logger.warning("\u30ed\u30b0\u8a2d\u5b9a: \u30ed\u30b0\u8a2d\u5b9a\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u30b9\u30c8\u30ea\u30fc\u30e0\u30af\u30ed\u30fc\u30ba\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.toString());
                }
            }
        }
        return logger;
    }
}

