/*
 * Decompiled with CFR 0.152.
 */
package jp.co.areaweb.tools.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class Command {
    public static final boolean debug = false;
    private String cmd;
    private File workDir;
    private BufferedReader stdReader = null;
    private BufferedReader errReader = null;

    public void execCommand() throws IOException {
        if (this.getCmd() == null || this.getCmd().equals("")) {
            return;
        }
        Process process = this.getWorkDir() == null ? Runtime.getRuntime().exec(this.getCmd()) : Runtime.getRuntime().exec(this.getCmd(), null, this.getWorkDir());
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.errReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        this.stdReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
    }

    public String getOutput() throws IOException {
        String std = this.getStdout();
        if (std.equals("")) {
            return this.getErrout();
        }
        return std + "\n" + this.getErrout();
    }

    public String getStdout() throws IOException {
        return Command.convBufferedReader(this.stdReader);
    }

    public String getErrout() throws IOException {
        return Command.convBufferedReader(this.errReader);
    }

    private static String convBufferedReader(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return "";
        }
        StringBuffer strbuf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            strbuf.append(line + "\n");
        }
        reader.close();
        reader = null;
        return strbuf.toString();
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("exp: java tool.job.Command [commandLine]");
            return;
        }
        String commandLine = "";
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                commandLine = commandLine + " ";
            }
            commandLine = commandLine + args[i];
        }
        System.out.println(commandLine);
        Command command = new Command();
        String stdout = "";
        String errout = "";
        try {
            command.setCmd(commandLine);
            command.setWorkDir(null);
            command.execCommand();
            stdout = command.getStdout();
            errout = command.getErrout();
            System.out.println("STD_OUT:");
            System.out.println(stdout);
            System.out.println("STD_ERROR:");
            System.out.println(errout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(commandLine);
        command = new Command();
        try {
            command.setCmd(commandLine);
            command.setWorkDir(null);
            command.execCommand();
            System.out.println(command.getOutput());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

