/*
 * Decompiled with CFR 0.152.
 */
package jp.co.areaweb.tools.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.co.areaweb.tools.command.Command;
import jp.co.areaweb.tools.command.Xalan;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlJob {
    public static final boolean debug = false;

    public static void execJob(File jobFile) throws Exception {
        XmlJob.execJob(jobFile, null);
    }

    public static void execJob(File jobFile, File workDir) throws Exception {
        if (jobFile == null) {
            throw new IOException("\u5b9f\u884c\u3059\u308b\u30b8\u30e7\u30d6\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document rootNode = builder.parse(new FileInputStream(jobFile));
        NodeList nl = rootNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node jobgroupTag = nl.item(i);
            if (jobgroupTag.getNodeType() != 1) continue;
            if (jobgroupTag.getNodeName().equals("jobgroup")) {
                XmlJob.execJobElement(jobFile, workDir, jobgroupTag.getChildNodes());
                continue;
            }
            if (!jobgroupTag.getNodeName().equals("xalan")) continue;
            Xalan.execJobElement(jobgroupTag.getChildNodes(), workDir);
        }
    }

    protected static void execJobElement(File jobFile, File workDir, NodeList jobgroupNodes) throws Exception {
        String stdout = null;
        String errout = null;
        Vector<Command> commands = new Vector<Command>();
        for (int i = 0; i < jobgroupNodes.getLength(); ++i) {
            NamedNodeMap attrs;
            Node node = jobgroupNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String tagName = node.getNodeName();
            if (tagName.equals("job")) {
                NodeList jobNodes = node.getChildNodes();
                Command command = new Command();
                for (int j = 0; j < jobNodes.getLength(); ++j) {
                    Node jobNode = jobNodes.item(j);
                    if (jobNode.getNodeType() != 1) continue;
                    String tagName2 = jobNode.getNodeName();
                    if (tagName2.equals("cmd")) {
                        command.setCmd(jobNode.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!tagName2.equals("workDir")) continue;
                    command.setWorkDir(new File(jobNode.getFirstChild().getNodeValue()));
                }
                commands.addElement(command);
                continue;
            }
            if (tagName.equals("stdout")) {
                attrs = node.getAttributes();
                stdout = attrs.getNamedItem("file").getNodeValue();
                continue;
            }
            if (!tagName.equals("errout")) continue;
            attrs = node.getAttributes();
            errout = attrs.getNamedItem("file").getNodeValue();
        }
        XmlJob.execJobs(stdout, errout, commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void execJobs(String stdout, String errout, Vector<Command> commands) throws IOException {
        try (PrintWriter stdoutPW = stdout == null ? new PrintWriter(System.out) : new PrintWriter(new OutputStreamWriter(new FileOutputStream(new File(stdout))));){
            for (int i = 0; i < commands.size(); ++i) {
                Command command = commands.get(i);
                command.execCommand();
                stdoutPW.println(command.getOutput());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("exp: java tool.job.XmlJob [jobFileName]");
            return;
        }
        XmlJob.execJob(new File(args[0]));
    }
}

