/*
 * Decompiled with CFR 0.152.
 */
package jp.co.areaweb.tools.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.LinkedList;
import jp.co.areaweb.tools.csv.CsvRecord;

public class CsvFile
extends LinkedList<CsvRecord> {
    protected String charsetName = "Windows-31J";
    protected File file;
    protected LinkedList<CsvRecord> allRecords = new LinkedList();

    public CsvFile(String pathname) {
        this(new File(pathname));
    }

    public CsvFile(File file) {
        this.file = file;
    }

    public void load() throws Exception {
        this.load(0);
    }

    public void load(int limit) throws Exception {
        String line;
        this.clear();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.charsetName));
        for (int i = 0; (limit <= 0 || i < limit) && (line = reader.readLine()) != null; ++i) {
            CsvRecord record = new CsvRecord();
            record.analizeRecord(line);
            this.add(record);
        }
        reader.close();
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public CsvFile find(int index, String dataStr) {
        CsvFile result = new CsvFile(this.file);
        for (CsvRecord record : this) {
            String data = (String)record.get(index);
            if (!data.equals(dataStr)) continue;
            result.add(record);
        }
        return result;
    }

    public void save() throws IOException {
        this.save(this.getFile());
    }

    public void save(File outputFile) throws IOException {
        FileOutputStream fo = new FileOutputStream(outputFile);
        PrintStream ps = new PrintStream(fo);
        for (CsvRecord record : this) {
            ps.println(record.toString());
        }
        ps.close();
        fo.close();
    }
}

