/*
 * Decompiled with CFR 0.152.
 */
package jp.co.areaweb.tools.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import jp.co.areaweb.tools.csv.CsvRecord;

public class CsvReader {
    int size = 0;
    int columnSize = 0;
    boolean titleLine = false;
    File file = null;
    String split = ",";
    protected String charsetName = "Windows-31J";
    LineNumberReader reader;

    public static void main(String[] args) throws Exception {
        File file = new File("test.csv");
        CsvReader obj = new CsvReader(file, true, ",");
        int size = obj.load();
        System.out.println("line count = " + obj.size());
        for (int i = 0; i < size; ++i) {
            System.out.print(String.format("%05d : ", i));
            CsvRecord rec = obj.get(i);
            if (rec != null) {
                System.out.println(rec.toString());
                continue;
            }
            System.out.println("< null >");
        }
    }

    public CsvReader(File file) throws UnsupportedEncodingException, IOException {
        this(file, false, ",");
    }

    public CsvReader(File file, boolean titleLine, String split) throws UnsupportedEncodingException, IOException {
        this.file = file;
        this.titleLine = titleLine;
        this.reader = null;
        this.split = split;
    }

    public int load() throws Exception {
        this.reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.charsetName));
        this.reader.mark(0x800000);
        this.size = 0;
        this.columnSize = 0;
        while (this.reader.readLine() != null) {
            ++this.size;
        }
        return this.size;
    }

    public CsvRecord get(int index) {
        if (index < 0 || index > this.size) {
            return null;
        }
        try {
            this.reader.reset();
            for (int i = 0; i < index; ++i) {
                this.reader.readLine();
            }
            String line = this.reader.readLine();
            if (line != null) {
                CsvRecord record = new CsvRecord();
                record.analizeRecord(line, this.split);
                return record;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public LinkedList<CsvRecord> find(int index, String dataStr) throws IOException {
        if (index < 0 || index > this.size) {
            return null;
        }
        LinkedList<CsvRecord> result = new LinkedList<CsvRecord>();
        this.reader.reset();
        for (int i = 0; i < this.size; ++i) {
            String line = this.reader.readLine();
            if (line == null) continue;
            CsvRecord record = new CsvRecord();
            record.analizeRecord(line, this.split);
            String item = (String)record.get(index);
            if (item == null || !item.trim().equals(dataStr)) continue;
            result.add(record);
        }
        return result;
    }

    public int size() {
        return this.size;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getCharsetName() {
        return this.charsetName;
    }
}

