/*
 * Decompiled with CFR 0.152.
 */
package jp.co.areaweb.tools.database;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import jp.co.areaweb.tools.core.JapaneseString;
import jp.co.areaweb.tools.database.DatabaseTool;

public class Select {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("exp: java jp.co.areaweb.tools.database.Select [propertieFile] [sqlfile]");
        } else {
            Select.doSQL(args[0], args[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSQL(String propertieFile, String sqlfile) {
        Connection conn = null;
        try {
            conn = DatabaseTool.openDb(propertieFile);
            BufferedReader ds = new BufferedReader(new InputStreamReader(new FileInputStream(sqlfile)));
            String sqlStr = "";
            while ((sqlStr = ds.readLine()) != null) {
                if ((sqlStr = JapaneseString.trim(sqlStr)).endsWith(";")) {
                    sqlStr = sqlStr.substring(0, sqlStr.length() - 1);
                }
                System.out.println(sqlStr);
                Select.sqlExecute(conn, sqlStr);
            }
            ds.close();
            System.out.println("SQL Finished");
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                DatabaseTool.closeDb(conn);
            }
        }
    }

    public static void sqlExecute(Connection conn, String sqlStr) throws SQLException {
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(sqlStr);
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        while (rs.next()) {
            for (int column = 1; column <= count; ++column) {
                System.out.print("'" + rs.getString(column) + "'");
                if (column >= count) continue;
                System.out.print(",");
            }
            System.out.print("\n");
        }
        rs.close();
        statement.close();
    }
}

