/*
 * Decompiled with CFR 0.152.
 */
package jp.co.areaweb.tools.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import jp.co.areaweb.tools.mail.SiteData;

public class SendMail {
    protected Vector<String> toVector = new Vector();
    protected Vector<String> ccVector = new Vector();
    protected Vector<String> bccVector = new Vector();
    protected String from = null;
    protected String subject;
    protected String content;
    protected String mailHost;
    protected String mailHostPort;
    protected Vector<File> attachments = new Vector();
    protected Vector<String> attachNames = new Vector();
    protected boolean POP_before_SMTP = false;
    protected boolean USER_AUTH = false;
    protected String popServer = "";
    protected String userId = "";
    protected String password = "";
    protected Session session = null;

    public static void main(String[] args) {
        try {
            SendMail mail = new SendMail("yuumail.properties");
            mail.setSubject("[proxSafe] SendMail \u30c6\u30b9\u30c8");
            mail.setContent("\u672c\u6587\n");
            mail.setAttachment(new File("mail-1.4.jar"));
            mail.send();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SendMail(String propertyFile) {
        this(new SiteData(propertyFile));
    }

    public SendMail(SiteData siteData) {
        if (!siteData.MAIL_SMTP.equals("")) {
            this.setMailHost(siteData.MAIL_SMTP);
        }
        if (!siteData.MAIL_SMTP_PORT.equals("")) {
            this.setMailPort(siteData.MAIL_SMTP_PORT);
        }
        if (!siteData.MAIL_TO.equals("")) {
            this.toVector.addElement(siteData.MAIL_TO);
        }
        if (!siteData.MAIL_CC.equals("")) {
            this.ccVector.addElement(siteData.MAIL_CC);
        }
        if (!siteData.MAIL_BCC.equals("")) {
            this.bccVector.addElement(siteData.MAIL_BCC);
        }
        if (!siteData.MAIL_FROM.equals("")) {
            this.from = siteData.MAIL_FROM;
        }
        this.POP_before_SMTP = siteData.POP_before_SMTP;
        this.USER_AUTH = siteData.USER_AUTH;
        this.popServer = siteData.MAIL_POP;
        this.userId = siteData.USER_ID;
        this.password = siteData.PASSWORD;
        Properties props = System.getProperties();
        props.put("mail.smtp.host", this.getMailHost());
        props.put("mail.smtp.port", this.getMailPort());
        if (this.USER_AUTH) {
            props.put("mail.smtp.auth", "true");
        }
        this.session = Session.getDefaultInstance((Properties)props, null);
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailHost(String mailHost) {
        this.mailHost = mailHost;
    }

    public String getMailPort() {
        return this.mailHostPort;
    }

    public void setMailPort(String portStr) {
        this.mailHostPort = portStr;
    }

    public void setTo(String to) {
        if (!to.equals("")) {
            this.toVector.addElement(to);
        }
    }

    public void setCc(String cc) {
        if (!cc.equals("")) {
            this.ccVector.addElement(cc);
        }
    }

    public void setBcc(String bcc) {
        if (!bcc.equals("")) {
            this.bccVector.addElement(bcc);
        }
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setAttachment(File attachment) throws FileNotFoundException {
        new FileInputStream(attachment);
        this.attachments.addElement(attachment);
        this.attachNames.addElement(attachment.getName());
    }

    public void setAttachment(File attachment, String name) throws FileNotFoundException {
        new FileInputStream(attachment);
        this.attachments.addElement(attachment);
        this.attachNames.addElement(name);
    }

    public void send() throws MessagingException, UnsupportedEncodingException {
        Store store = null;
        if (this.POP_before_SMTP) {
            System.out.println("store.connect(" + this.popServer + ", '" + this.userId + "', '" + this.password + "')");
            store = this.session.getStore("pop3");
            store.connect(this.popServer, this.userId, this.password);
        } else {
            System.out.println("no POP_before_SMTP!");
        }
        MimeMessage message = this.createMessage();
        if (this.USER_AUTH) {
            System.out.println("transport.connect(null, '" + this.userId + "', '" + this.password + "')");
            Transport transport = this.session.getTransport("smtp");
            transport.connect(null, this.userId, this.password);
            transport.sendMessage((Message)message, message.getAllRecipients());
        } else {
            System.out.println("no SMTP_AUTH!");
            Transport.send((Message)message);
        }
        if (this.POP_before_SMTP) {
            store.close();
        }
    }

    protected MimeMessage createMessage() throws MessagingException, UnsupportedEncodingException {
        MimeMessage msg = new MimeMessage(this.session);
        InternetAddress[] toList = new InternetAddress[this.toVector.size()];
        for (int i = 0; i < this.toVector.size(); ++i) {
            toList[i] = new InternetAddress(this.toVector.elementAt(i));
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])toList);
        InternetAddress[] ccList = new InternetAddress[this.ccVector.size()];
        for (int i = 0; i < this.ccVector.size(); ++i) {
            ccList[i] = new InternetAddress(this.ccVector.elementAt(i));
        }
        msg.setRecipients(Message.RecipientType.CC, (Address[])ccList);
        InternetAddress[] bccList = new InternetAddress[this.bccVector.size()];
        for (int i = 0; i < this.bccVector.size(); ++i) {
            bccList[i] = new InternetAddress(this.bccVector.elementAt(i));
        }
        msg.setRecipients(Message.RecipientType.BCC, (Address[])bccList);
        msg.setFrom((Address)new InternetAddress(this.getFrom()));
        msg.setSubject(MimeUtility.encodeText((String)this.getSubject(), (String)"iso-2022-jp", (String)"B"));
        MimeMultipart naiyou = new MimeMultipart();
        msg.setContent((Multipart)naiyou);
        MimeBodyPart honbun = new MimeBodyPart();
        honbun.setContent((Object)this.getContent(), "text/plain; charset=\"iso-2022-jp\"");
        naiyou.addBodyPart((BodyPart)honbun);
        for (int i = 0; i < this.attachments.size(); ++i) {
            File attachFile = this.attachments.elementAt(i);
            MimeBodyPart tenpu = new MimeBodyPart();
            FileDataSource dfs = new FileDataSource(attachFile);
            DataHandler dh = new DataHandler((DataSource)dfs);
            tenpu.setDataHandler(dh);
            tenpu.setFileName(this.attachNames.elementAt(i));
            naiyou.addBodyPart((BodyPart)tenpu);
        }
        return msg;
    }
}

