/*
 * Decompiled with CFR 0.152.
 */
package jp.co.areaweb.tools.mail;

import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.areaweb.tools.mail.SiteData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SiteDataXml
extends SiteData {
    public SiteDataXml(String propertyFile) throws ParserConfigurationException, SAXException {
        super(propertyFile);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document rootNode = builder.parse(new FileInputStream(propertyFile));
            NodeList rootNodeList = rootNode.getChildNodes();
            for (int j = 0; j < rootNodeList.getLength(); ++j) {
                Node propertyTag = rootNodeList.item(j);
                NodeList nl = propertyTag.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node mailDataTag = nl.item(i);
                    if (mailDataTag.getNodeType() != 1) continue;
                    String nodeName = mailDataTag.getNodeName();
                    if (nodeName.equals("smtp")) {
                        this.MAIL_SMTP = SiteDataXml.paseValue(mailDataTag);
                        continue;
                    }
                    if (nodeName.equals("from")) {
                        this.MAIL_FROM = SiteDataXml.paseValue(mailDataTag);
                        continue;
                    }
                    if (nodeName.equals("to")) {
                        this.MAIL_TO = SiteDataXml.paseValue(mailDataTag);
                        continue;
                    }
                    if (nodeName.equals("cc")) {
                        this.MAIL_CC = SiteDataXml.paseValue(mailDataTag);
                        continue;
                    }
                    if (!nodeName.equals("bcc")) continue;
                    this.MAIL_BCC = SiteDataXml.paseValue(mailDataTag);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    protected static String paseValue(Node tag) {
        Node node = tag.getFirstChild();
        if (node != null) {
            return node.getNodeValue();
        }
        return "";
    }
}

