/*
 * Decompiled with CFR 0.152.
 */
package jp.co.areaweb.tools.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.areaweb.tools.mail.SendMail;
import jp.co.areaweb.tools.mail.SiteData;
import jp.co.areaweb.tools.mail.SiteDataXml;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class YuuMailXml
extends SendMail {
    public YuuMailXml(SiteData siteData) {
        super(siteData);
    }

    public YuuMailXml(String propertyFile) {
        super(propertyFile);
    }

    public void setXmlData(Node sendMailTag) throws FileNotFoundException {
        NodeList nl = sendMailTag.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node mailDataTag = nl.item(i);
            if (mailDataTag.getNodeType() != 1) continue;
            String nodeName = mailDataTag.getNodeName();
            if (nodeName.equals("to")) {
                this.setTo(mailDataTag.getFirstChild().getNodeValue());
                continue;
            }
            if (nodeName.equals("cc")) {
                Node ccNode = mailDataTag.getFirstChild();
                if (ccNode == null) continue;
                this.setCc(ccNode.getNodeValue());
                continue;
            }
            if (nodeName.equals("bcc")) {
                Node bccNode = mailDataTag.getFirstChild();
                if (bccNode == null) continue;
                this.setBcc(bccNode.getNodeValue());
                continue;
            }
            if (nodeName.equals("from")) {
                Node fromNode = mailDataTag.getFirstChild();
                if (fromNode == null) continue;
                this.setFrom(fromNode.getNodeValue());
                continue;
            }
            if (nodeName.equals("subject")) {
                this.setSubject(mailDataTag.getFirstChild().getNodeValue());
                continue;
            }
            if (nodeName.equals("content")) {
                this.setContent(mailDataTag.getFirstChild().getNodeValue());
                continue;
            }
            if (!nodeName.equals("attachment")) continue;
            Node attachNode = mailDataTag.getFirstChild();
            File attachFile = new File(attachNode.getNodeValue());
            Attr attrNode = (Attr)mailDataTag.getAttributes().getNamedItem("file");
            if (attrNode != null) {
                this.setAttachment(attachFile, attrNode.getValue());
                continue;
            }
            this.setAttachment(attachFile);
        }
    }

    public void setXmlData(String inputFile) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document rootNode = builder.parse(new FileInputStream(inputFile));
            NodeList rootNodeList = rootNode.getChildNodes();
            for (int j = 0; j < rootNodeList.getLength(); ++j) {
                this.setXmlData(rootNodeList.item(j));
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new IOException("javax.xml.parsers.ParserConfigurationException");
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
            throw new IOException("org.xml.sax.SAXException");
        }
    }

    public static void main(String[] args) {
        String propertyFile;
        String inputfile;
        if (args.length < 2) {
            inputfile = "sendMail.xml";
            propertyFile = args.length < 1 ? "property.xml" : args[0];
        } else {
            inputfile = args[1];
            propertyFile = args[0];
        }
        try {
            YuuMailXml mail = new YuuMailXml(new SiteDataXml(propertyFile));
            mail.setXmlData(inputfile);
            mail.send();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

