/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.composite;

import com.clustercontrol.syslogng.action.GetLogFilterListTableDefine;
import com.clustercontrol.syslogng.action.LogManager;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.composite.LogFilterInfoTableViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class LogListComposite
extends Composite {
    private LogFilterInfoTableViewer tableViewer = null;

    public LogListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new LogFilterInfoTableViewer(table);
        this.tableViewer.createTableColumn(GetLogFilterListTableDefine.get());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        LogManager.getInstance().initialize();
        this.update();
    }

    public LogFilterInfoTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public LogFilterInfo getFilterItem() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection == null) {
            return null;
        }
        return (LogFilterInfo)selection.getFirstElement();
    }

    public void update() {
        Object[] list = LogManager.getInstance().get();
        this.tableViewer.setInput(list);
    }
}

