/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.composite;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.repository.action.GetScopeList;
import com.clustercontrol.repository.action.GetScopeListTableDefine;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ScopeListComposite
extends Composite {
    protected FacilityTreeItem m_facilityTreeItem = null;
    protected FacilityTreeItem m_selectFacilityTreeItem = null;
    private CommonTableViewer tableViewer = null;
    private Label totalLabel = null;

    public ScopeListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.totalLabel = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.totalLabel.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetScopeListTableDefine.get(), 0, 1);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                ArrayList item = (ArrayList)selection.getFirstElement();
                if (item instanceof ArrayList) {
                    String facilityId = (String)item.get(0);
                    FacilityTreeItem[] items = ScopeListComposite.this.getFacilityTreeItem().getChildren();
                    int i = 0;
                    while (i < items.length) {
                        if (facilityId.equals(items[i].getData().getFacilityId())) {
                            ScopeListComposite.this.m_selectFacilityTreeItem = items[i];
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public void update(FacilityTreeItem item) {
        ArrayList list = null;
        if (item instanceof FacilityTreeItem) {
            this.m_facilityTreeItem = item;
            String facilityId = item.getData().getFacilityId();
            int type = item.getData().getType();
            if (type != 1) {
                list = new GetScopeList().getScopeList(facilityId);
            }
        }
        if (list == null) {
            list = new ArrayList();
        }
        this.tableViewer.setInput(list);
        Object[] args = new Object[]{String.valueOf(list.size())};
        this.totalLabel.setText(Messages.getString((String)"records", (Object[])args));
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public FacilityTreeItem getSelectItem() {
        return this.m_selectFacilityTreeItem;
    }

    public FacilityTreeItem getFacilityTreeItem() {
        return this.m_facilityTreeItem;
    }
}

