/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.ModifySchedule;
import com.clustercontrol.monitor.run.factory.SelectSchedule;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class ModifyMonitor {
    protected static Log m_log = LogFactory.getLog(ModifyMonitor.class);
    protected MonitorInfoLocal m_monitor;
    protected MonitorInfo m_monitorInfo;
    protected boolean m_isModifyFacilityId;
    protected boolean m_isModifyRunInterval;
    protected boolean m_isModifyValid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean modify(MonitorInfo info) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        AccessLock.lock((String)"MONITOR");
        this.m_monitorInfo = info;
        TransactionManager tm = null;
        Transaction tx = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            if (tm.getTransaction() != null) {
                oldTx = tm.suspend();
            }
            try {
                if (tm.getTransaction() == null) {
                    tm.begin();
                    tx = tm.getTransaction();
                }
                if (result = this.modifyMonitorInfo()) {
                    tx.commit();
                }
            }
            catch (NotSupportedException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            catch (RollbackException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            catch (HeuristicMixedException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            catch (HeuristicRollbackException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            finally {
                if (tx != null) {
                    if (!result) {
                        tx.rollback();
                    }
                    tx = null;
                }
            }
            if (oldTx == null) return result;
        }
        catch (Throwable throwable) {
            if (oldTx == null) throw throwable;
            try {
                tm.resume(oldTx);
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            catch (IllegalStateException e) {
                this.outputLog(e, "modify()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
        }
        try {
            tm.resume(oldTx);
            return result;
        }
        catch (InvalidTransactionException e) {
            this.outputLog((Exception)((Object)e), "modify()");
            throw e;
        }
        catch (IllegalStateException e) {
            this.outputLog(e, "modify()");
            throw e;
        }
        catch (SystemException e) {
            this.outputLog((Exception)((Object)e), "modify()");
            throw e;
        }
    }

    public abstract boolean modifyJudgementInfo() throws CreateException, RemoveException, NamingException;

    public abstract boolean modifyCheckInfo() throws CreateException, FinderException, NamingException;

    public Calendar getCalendar(int interval) {
        return null;
    }

    protected boolean modifyMonitorInfo() throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException {
        try {
            MonitorInfoPK pk = new MonitorInfoPK(this.m_monitorInfo.getMonitorId(), this.m_monitorInfo.getMonitorTypeId());
            this.m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);
            if (!this.m_monitorInfo.getFacilityId().equals(this.m_monitor.getFacilityId())) {
                this.m_isModifyFacilityId = true;
            }
            if (this.m_monitorInfo.getRunInterval().intValue() != this.m_monitor.getRunInterval().intValue()) {
                this.m_isModifyRunInterval = true;
            }
            if (!this.m_isModifyRunInterval) {
                int oldValid = new SelectSchedule().getValid(this.m_monitorInfo.getMonitorTypeId(), this.m_monitorInfo.getMonitorId());
                if (this.m_monitorInfo.getValid() != oldValid) {
                    this.m_isModifyValid = true;
                }
            }
            this.m_monitor.setDescription(this.m_monitorInfo.getDescription());
            if (this.m_isModifyFacilityId) {
                this.m_monitor.setFacilityId(this.m_monitorInfo.getFacilityId());
            }
            if (this.m_isModifyRunInterval) {
                this.m_monitor.setRunInterval(this.m_monitorInfo.getRunInterval());
            }
            this.m_monitor.setMonitorBlock(this.m_monitorInfo.getMonitorBlock());
            this.m_monitor.setDeterminationId(this.m_monitorInfo.getDeterminationId());
            this.m_monitor.setFailurePriority(this.m_monitorInfo.getFailurePriority());
            this.m_monitor.setNotifyId(this.m_monitorInfo.getNotifyId());
            this.m_monitor.setApplication(this.m_monitorInfo.getApplication());
            this.m_monitor.setUpdateDate(new Timestamp(new Date().getTime()));
            if (this.modifyJudgementInfo() && this.modifyCheckInfo()) {
                if (this.m_isModifyRunInterval || this.m_isModifyValid) {
                    ModifySchedule quartz = new ModifySchedule();
                    quartz.modifySchedule(this.m_monitorInfo, this.getCalendar(this.m_monitorInfo.getRunInterval()));
                }
                return true;
            }
            return false;
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            throw e;
        }
        catch (RemoveException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            throw e;
        }
        catch (SchedulerException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            throw e;
        }
        catch (ParseException e) {
            this.outputLog(e, "modifyMonitorInfo()");
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "modifyMonitorInfo()");
            throw e;
        }
    }

    private void outputLog(Exception e, String method) {
        AplLogger apllog = new AplLogger("MON", "mon");
        Object[] args = new String[]{this.m_monitorInfo.getMonitorTypeId(), this.m_monitorInfo.getMonitorId()};
        apllog.put("SYS", "008", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

