/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import org.jboss.mx.util.AgentID;
import org.jboss.mx.util.DefaultExceptionHandler;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.ProxyContext;
import org.jboss.mx.util.ProxyExceptionHandler;

public class JMXInvocationHandler
implements ProxyContext,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 3714728148040623702L;
    protected MBeanServer server = null;
    protected ObjectName objectName = null;
    private ProxyExceptionHandler handler = new DefaultExceptionHandler();
    private HashMap attributeMap = new HashMap();
    private boolean delegateToStringToResource = false;
    private boolean delegateEqualsToResource = false;
    private boolean delegateHashCodeToResource = false;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$jboss$mx$util$ProxyContext;
    static /* synthetic */ Class class$javax$management$DynamicMBean;
    static /* synthetic */ Class class$java$lang$Boolean;

    public JMXInvocationHandler(MBeanServer server, ObjectName name) throws MBeanProxyCreationException {
        try {
            int i;
            if (server == null) {
                throw new MBeanProxyCreationException("null agent reference");
            }
            this.server = server;
            this.objectName = name;
            MBeanInfo info = server.getMBeanInfo(this.objectName);
            MBeanAttributeInfo[] attributes = info.getAttributes();
            MBeanOperationInfo[] operations = info.getOperations();
            for (i = 0; i < attributes.length; ++i) {
                this.attributeMap.put(attributes[i].getName(), attributes[i]);
            }
            for (i = 0; i < operations.length; ++i) {
                if (operations[i].getName().equals("toString") && operations[i].getReturnType().equals("java.lang.String") && operations[i].getSignature().length == 0) {
                    this.delegateToStringToResource = true;
                    continue;
                }
                if (operations[i].getName().equals("equals") && operations[i].getReturnType().equals(Boolean.TYPE.getName()) && operations[i].getSignature().length == 1 && operations[i].getSignature()[0].getType().equals("java.lang.Object")) {
                    this.delegateEqualsToResource = true;
                    continue;
                }
                if (!operations[i].getName().equals("hashCode") || !operations[i].getReturnType().equals(Integer.TYPE.getName()) || operations[i].getSignature().length != 0) continue;
                this.delegateHashCodeToResource = true;
            }
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanProxyCreationException("Object name " + name + " not found: " + e.toString());
        }
        catch (IntrospectionException e) {
            throw new MBeanProxyCreationException(e.toString());
        }
        catch (ReflectionException e) {
            throw new MBeanProxyCreationException(e.toString());
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == (class$java$lang$Object == null ? (class$java$lang$Object = JMXInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.handleObjectMethods(method, args);
        }
        if (declaringClass == (class$org$jboss$mx$util$ProxyContext == null ? (class$org$jboss$mx$util$ProxyContext = JMXInvocationHandler.class$("org.jboss.mx.util.ProxyContext")) : class$org$jboss$mx$util$ProxyContext)) {
            return method.invoke((Object)this, args);
        }
        if (declaringClass == (class$javax$management$DynamicMBean == null ? (class$javax$management$DynamicMBean = JMXInvocationHandler.class$("javax.management.DynamicMBean")) : class$javax$management$DynamicMBean)) {
            return this.handleDynamicMBeanInvocation(method, args);
        }
        try {
            Object retType;
            MBeanAttributeInfo info;
            String attrName;
            String methodName = method.getName();
            if (methodName.startsWith("get") && args == null) {
                attrName = methodName.substring(3, methodName.length());
                info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
                if (info != null && ((String)(retType = method.getReturnType().getName())).equals(info.getType())) {
                    return this.server.getAttribute(this.objectName, attrName);
                }
            } else if (methodName.startsWith("is") && args == null) {
                attrName = methodName.substring(2, methodName.length());
                info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
                if (info != null && info.isIs() && ((retType = method.getReturnType()).equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JMXInvocationHandler.class$("java.lang.Boolean")) : class$java$lang$Boolean) || retType.equals(Boolean.TYPE))) {
                    return this.server.getAttribute(this.objectName, attrName);
                }
            } else if (methodName.startsWith("set") && args != null && args.length == 1 && (info = (MBeanAttributeInfo)this.attributeMap.get(attrName = methodName.substring(3, methodName.length()))) != null && method.getReturnType().equals(Void.TYPE)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> signatureClass = null;
                String classType = info.getType();
                signatureClass = this.isPrimitive(classType) ? this.getPrimitiveClass(classType) : cl.loadClass(info.getType());
                if (signatureClass.isAssignableFrom(args[0].getClass())) {
                    this.server.setAttribute(this.objectName, new Attribute(attrName, args[0]));
                    return null;
                }
            }
            String[] signature = null;
            if (args != null) {
                signature = new String[args.length];
                Class<?>[] sign = method.getParameterTypes();
                for (int i = 0; i < sign.length; ++i) {
                    signature[i] = sign[i].getName();
                }
            }
            return this.server.invoke(this.objectName, methodName, args, signature);
        }
        catch (InstanceNotFoundException e) {
            return this.getExceptionHandler().handleInstanceNotFound(this, e, method, args);
        }
        catch (AttributeNotFoundException e) {
            return this.getExceptionHandler().handleAttributeNotFound(this, e, method, args);
        }
        catch (InvalidAttributeValueException e) {
            return this.getExceptionHandler().handleInvalidAttributeValue(this, e, method, args);
        }
        catch (MBeanException e) {
            return this.getExceptionHandler().handleMBeanException(this, e, method, args);
        }
        catch (ReflectionException e) {
            return this.getExceptionHandler().handleReflectionException(this, e, method, args);
        }
        catch (RuntimeOperationsException e) {
            return this.getExceptionHandler().handleRuntimeOperationsException(this, e, method, args);
        }
        catch (RuntimeMBeanException e) {
            return this.getExceptionHandler().handleRuntimeMBeanException(this, e, method, args);
        }
        catch (RuntimeErrorException e) {
            return this.getExceptionHandler().handleRuntimeError(this, e, method, args);
        }
    }

    public ProxyExceptionHandler getExceptionHandler() {
        return this.handler;
    }

    public void setExceptionHandler(ProxyExceptionHandler handler) {
        this.handler = handler;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String toString() {
        return "MBeanProxy for " + this.objectName + " (Agent ID: " + AgentID.get(this.server) + ")";
    }

    private Object handleObjectMethods(Method method, Object[] args) throws InstanceNotFoundException, ReflectionException, IntrospectionException, MBeanException {
        if (method.getName().equals("toString")) {
            if (this.delegateToStringToResource) {
                return this.server.invoke(this.objectName, "toString", null, null);
            }
            return this.toString();
        }
        if (method.getName().equals("equals")) {
            if (this.delegateEqualsToResource) {
                return this.server.invoke(this.objectName, "equals", new Object[]{args[0]}, new String[]{"java.lang.Object"});
            }
            if (Proxy.isProxyClass(args[0].getClass())) {
                Proxy prxy = (Proxy)args[0];
                return new Boolean(this.equals(Proxy.getInvocationHandler(prxy)));
            }
            return new Boolean(this.equals(args[0]));
        }
        if (method.getName().equals("hashCode")) {
            if (this.delegateHashCodeToResource) {
                return this.server.invoke(this.objectName, "hashCode", null, null);
            }
            return new Integer(this.hashCode());
        }
        throw new Error("Unexpected method invocation!");
    }

    private Object handleDynamicMBeanInvocation(Method method, Object[] args) throws InstanceNotFoundException, ReflectionException, IntrospectionException, MBeanException, AttributeNotFoundException, InvalidAttributeValueException {
        String methodName = method.getName();
        if (methodName.equals("setAttribute")) {
            this.server.setAttribute(this.objectName, (Attribute)args[0]);
            return null;
        }
        if (methodName.equals("setAttributes")) {
            return this.server.setAttributes(this.objectName, (AttributeList)args[0]);
        }
        if (methodName.equals("getAttribute")) {
            return this.server.getAttribute(this.objectName, (String)args[0]);
        }
        if (methodName.equals("getAttributes")) {
            return this.server.getAttributes(this.objectName, (String[])args[0]);
        }
        if (methodName.equals("invoke")) {
            return this.server.invoke(this.objectName, (String)args[0], (Object[])args[1], (String[])args[2]);
        }
        if (methodName.equals("getMBeanInfo")) {
            return this.server.getMBeanInfo(this.objectName);
        }
        throw new Error("Unexpected method invocation!");
    }

    private boolean isPrimitive(String type) {
        if (type.equals(Integer.TYPE.getName())) {
            return true;
        }
        if (type.equals(Long.TYPE.getName())) {
            return true;
        }
        if (type.equals(Boolean.TYPE.getName())) {
            return true;
        }
        if (type.equals(Byte.TYPE.getName())) {
            return true;
        }
        if (type.equals(Character.TYPE.getName())) {
            return true;
        }
        if (type.equals(Short.TYPE.getName())) {
            return true;
        }
        if (type.equals(Float.TYPE.getName())) {
            return true;
        }
        if (type.equals(Double.TYPE.getName())) {
            return true;
        }
        return type.equals(Void.TYPE.getName());
    }

    private Class getPrimitiveClass(String type) {
        if (type.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (type.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (type.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (type.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (type.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (type.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        if (type.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (type.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (type.equals(Void.TYPE.getName())) {
            return Void.TYPE;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

