/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

public class BerEncoder {
    public static final int BooleanTag = 1;
    public static final int IntegerTag = 2;
    public static final int OctetStringTag = 4;
    public static final int NullTag = 5;
    public static final int OidTag = 6;
    public static final int SequenceTag = 48;
    protected final byte[] bytes;
    protected int start = -1;
    protected final int[] stackBuf = new int[200];
    protected int stackTop = 0;

    public BerEncoder(byte[] byArray) {
        this.bytes = byArray;
        this.start = byArray.length;
        this.stackTop = 0;
    }

    public int trim() {
        int n2 = this.bytes.length - this.start;
        if (n2 > 0) {
            System.arraycopy(this.bytes, this.start, this.bytes, 0, n2);
        }
        this.start = this.bytes.length;
        this.stackTop = 0;
        return n2;
    }

    public void putInteger(int n2) {
        this.putInteger(n2, 2);
    }

    public void putInteger(int n2, int n3) {
        this.putIntegerValue(n2);
        this.putTag(n3);
    }

    public void putInteger(long l2) {
        this.putInteger(l2, 2);
    }

    public void putInteger(long l2, int n2) {
        this.putIntegerValue(l2);
        this.putTag(n2);
    }

    public void putOctetString(byte[] byArray) {
        this.putOctetString(byArray, 4);
    }

    public void putOctetString(byte[] byArray, int n2) {
        this.putStringValue(byArray);
        this.putTag(n2);
    }

    public void putOid(long[] lArray) {
        this.putOid(lArray, 6);
    }

    public void putOid(long[] lArray, int n2) {
        this.putOidValue(lArray);
        this.putTag(n2);
    }

    public void putNull() {
        this.putNull(5);
    }

    public void putNull(int n2) {
        this.putLength(0);
        this.putTag(n2);
    }

    public void putAny(byte[] byArray) {
        this.putAny(byArray, byArray.length);
    }

    public void putAny(byte[] byArray, int n2) {
        System.arraycopy(byArray, 0, this.bytes, this.start - n2, n2);
        this.start -= n2;
    }

    public void openSequence() {
        this.stackBuf[this.stackTop++] = this.start;
    }

    public void closeSequence() {
        this.closeSequence(48);
    }

    public void closeSequence(int n2) {
        int n3 = this.stackBuf[--this.stackTop];
        this.putLength(n3 - this.start);
        this.putTag(n2);
    }

    protected final void putTag(int n2) {
        if (n2 < 256) {
            this.bytes[--this.start] = (byte)n2;
        } else {
            while (n2 != 0) {
                this.bytes[--this.start] = (byte)(n2 & 0x7F);
                n2 <<= 7;
            }
        }
    }

    protected final void putLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 < 128) {
            this.bytes[--this.start] = (byte)n2;
        } else if (n2 < 256) {
            this.bytes[--this.start] = (byte)n2;
            this.bytes[--this.start] = -127;
        } else if (n2 < 65536) {
            this.bytes[--this.start] = (byte)n2;
            this.bytes[--this.start] = (byte)(n2 >> 8);
            this.bytes[--this.start] = -126;
        } else if (n2 < 0xFFFFA6) {
            this.bytes[--this.start] = (byte)n2;
            this.bytes[--this.start] = (byte)(n2 >> 8);
            this.bytes[--this.start] = (byte)(n2 >> 16);
            this.bytes[--this.start] = -125;
        } else {
            this.bytes[--this.start] = (byte)n2;
            this.bytes[--this.start] = (byte)(n2 >> 8);
            this.bytes[--this.start] = (byte)(n2 >> 16);
            this.bytes[--this.start] = (byte)(n2 >> 24);
            this.bytes[--this.start] = -124;
        }
    }

    protected final void putIntegerValue(int n2) {
        int n3;
        int n4 = this.start;
        int n5 = 2139095040;
        if (n2 < 0) {
            for (n3 = 4; (n5 & n2) == n5 && n3 > 1; n5 >>= 8, --n3) {
            }
        } else {
            while ((n5 & n2) == 0 && n3 > 1) {
                n5 >>= 8;
                --n3;
            }
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.bytes[--this.start] = (byte)n2;
            n2 >>= 8;
        }
        this.putLength(n4 - this.start);
    }

    protected final void putIntegerValue(long l2) {
        int n2;
        int n3 = this.start;
        long l3 = 9187343239835811840L;
        if (l2 < 0L) {
            for (n2 = 8; (l3 & l2) == l3 && n2 > 1; l3 >>= 8, --n2) {
            }
        } else {
            while ((l3 & l2) == 0L && n2 > 1) {
                l3 >>= 8;
                --n2;
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bytes[--this.start] = (byte)l2;
            l2 >>= 8;
        }
        this.putLength(n3 - this.start);
    }

    protected final void putStringValue(byte[] byArray) {
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, this.bytes, this.start - n2, n2);
        this.start -= n2;
        this.putLength(n2);
    }

    protected final void putOidValue(long[] lArray) {
        int n2 = this.start;
        int n3 = lArray.length;
        if (n3 < 2 || lArray[0] > 2L || lArray[1] >= 40L) {
            throw new IllegalArgumentException();
        }
        for (int i2 = n3 - 1; i2 >= 2; --i2) {
            long l2 = lArray[i2];
            if (l2 < 0L) {
                throw new IllegalArgumentException();
            }
            if (l2 < 128L) {
                this.bytes[--this.start] = (byte)l2;
                continue;
            }
            this.bytes[--this.start] = (byte)(l2 & 0x7FL);
            l2 >>= 7;
            while (l2 != 0L) {
                this.bytes[--this.start] = (byte)(l2 | 0x80L);
                l2 >>= 7;
            }
        }
        this.bytes[--this.start] = (byte)(lArray[0] * 40L + lArray[1]);
        this.putLength(n2 - this.start);
    }
}

