/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

public class SymbolTable {
    protected static final int TABLE_SIZE = 101;
    protected Entry[] fBuckets = null;
    protected int fTableSize;

    public SymbolTable() {
        this(101);
    }

    public SymbolTable(int n2) {
        this.fTableSize = n2;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public String addSymbol(String string) {
        int n2 = this.hash(string) % this.fTableSize;
        int n3 = string.length();
        Entry entry = this.fBuckets[n2];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (string.charAt(i2) == entry.characters[i2]) {
                            continue;
                        }
                        break block4;
                    }
                    return entry.symbol;
                }
            }
            entry = entry.next;
        }
        this.fBuckets[n2] = entry = new Entry(string, this.fBuckets[n2]);
        return entry.symbol;
    }

    public String addSymbol(char[] cArray, int n2, int n3) {
        int n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        Entry entry = this.fBuckets[n4];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (cArray[n2 + i2] == entry.characters[i2]) {
                            continue;
                        }
                        break block4;
                    }
                    return entry.symbol;
                }
            }
            entry = entry.next;
        }
        this.fBuckets[n4] = entry = new Entry(cArray, n2, n3, this.fBuckets[n4]);
        return entry.symbol;
    }

    public int hash(String string) {
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = n2 * 37 + string.charAt(i2);
        }
        return n2 & 0x7FFFFFF;
    }

    public int hash(char[] cArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = n4 * 37 + cArray[n2 + i2];
        }
        return n4 & 0x7FFFFFF;
    }

    public boolean containsSymbol(String string) {
        int n2 = this.hash(string) % this.fTableSize;
        int n3 = string.length();
        Entry entry = this.fBuckets[n2];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (string.charAt(i2) == entry.characters[i2]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] cArray, int n2, int n3) {
        int n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        Entry entry = this.fBuckets[n4];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (cArray[n2 + i2] == entry.characters[i2]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    protected static final class Entry {
        public String symbol;
        public char[] characters;
        public Entry next;

        public Entry(String string, Entry entry) {
            this.symbol = string.intern();
            this.characters = new char[string.length()];
            string.getChars(0, this.characters.length, this.characters, 0);
            this.next = entry;
        }

        public Entry(char[] cArray, int n2, int n3, Entry entry) {
            this.characters = new char[n3];
            System.arraycopy(cArray, n2, this.characters, 0, n3);
            this.symbol = new String(this.characters).intern();
            this.next = entry;
        }
    }
}

