/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.ProxyGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final String proxyClassNamePrefix = "$Proxy";
    private static final Class[] constructorParams = new Class[]{InvocationHandler.class};
    private static Map loaderToCache = new WeakHashMap();
    private static Object pendingGenerationMarker = new Object();
    private static long nextUniqueNumber = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Map proxyClasses = Collections.synchronizedMap(new WeakHashMap());
    protected InvocationHandler h;

    private Proxy() {
    }

    protected Proxy(InvocationHandler invocationHandler) {
        this.h = invocationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... classArray) throws IllegalArgumentException {
        HashMap<List<String>, Object> hashMap;
        HashMap<List<String>, Object> hashMap2;
        if (classArray.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        Class clazz = null;
        String[] stringArray = new String[classArray.length];
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            hashMap2 = classArray[i2].getName();
            hashMap = null;
            try {
                hashMap = Class.forName((String)((Object)hashMap2), false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (hashMap != classArray[i2]) {
                throw new IllegalArgumentException(classArray[i2] + " is not visible from class loader");
            }
            if (!((Class)((Object)hashMap)).isInterface()) {
                throw new IllegalArgumentException(((Class)((Object)hashMap)).getName() + " is not an interface");
            }
            if (hashSet.contains(hashMap)) {
                throw new IllegalArgumentException("repeated interface: " + ((Class)((Object)hashMap)).getName());
            }
            hashSet.add(hashMap);
            stringArray[i2] = hashMap2;
        }
        List<String> list = Arrays.asList(stringArray);
        hashMap = loaderToCache;
        synchronized (hashMap) {
            hashMap2 = (Map)loaderToCache.get(classLoader);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<List<String>, Object>();
                loaderToCache.put(classLoader, hashMap2);
            }
        }
        hashMap = hashMap2;
        synchronized (hashMap) {
            while (true) {
                Object v2;
                if ((v2 = hashMap2.get(list)) instanceof Reference) {
                    clazz = (Class)((Reference)v2).get();
                }
                if (clazz != null) {
                    return clazz;
                }
                if (v2 != pendingGenerationMarker) break;
                try {
                    hashMap2.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            hashMap2.put(list, pendingGenerationMarker);
        }
        try {
            long l2;
            Object object;
            hashMap = null;
            for (int i3 = 0; i3 < classArray.length; ++i3) {
                String string;
                int n2 = classArray[i3].getModifiers();
                if (Modifier.isPublic(n2)) continue;
                object = classArray[i3].getName();
                int n3 = ((String)object).lastIndexOf(46);
                String string2 = string = n3 == -1 ? "" : ((String)object).substring(0, n3 + 1);
                if (hashMap == null) {
                    hashMap = string;
                    continue;
                }
                if (string.equals(hashMap)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (hashMap == null) {
                hashMap = "";
            }
            object = nextUniqueNumberLock;
            synchronized (object) {
                l2 = nextUniqueNumber++;
            }
            object = (String)((Object)hashMap) + proxyClassNamePrefix + l2;
            byte[] byArray = ProxyGenerator.generateProxyClass((String)object, classArray);
            try {
                clazz = Proxy.defineClass0(classLoader, (String)object, byArray, 0, byArray.length);
            }
            catch (ClassFormatError classFormatError) {
                throw new IllegalArgumentException(classFormatError.toString());
            }
            proxyClasses.put(clazz, null);
        }
        finally {
            hashMap = hashMap2;
            synchronized (hashMap) {
                if (clazz != null) {
                    hashMap2.put(list, new WeakReference<Class>(clazz));
                } else {
                    hashMap2.remove(list);
                }
                hashMap2.notifyAll();
            }
        }
        return clazz;
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] classArray, InvocationHandler invocationHandler) throws IllegalArgumentException {
        if (invocationHandler == null) {
            throw new NullPointerException();
        }
        Class<?> clazz = Proxy.getProxyClass(classLoader, classArray);
        try {
            Constructor<?> constructor = clazz.getConstructor(constructorParams);
            return constructor.newInstance(invocationHandler);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError(instantiationException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError(invocationTargetException.toString());
        }
    }

    public static boolean isProxyClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return proxyClasses.containsKey(clazz);
    }

    public static InvocationHandler getInvocationHandler(Object object) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy proxy = (Proxy)object;
        return proxy.h;
    }

    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);
}

