/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CyclicBarrier {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition trip = this.lock.newCondition();
    private final int parties;
    private final Runnable barrierCommand;
    private Generation generation = new Generation();
    private int count;

    private void nextGeneration() {
        this.generation.tripped = true;
        this.trip.signalAll();
        this.count = this.parties;
        this.generation = new Generation();
    }

    private void breakBarrier() {
        this.generation.broken = true;
        this.count = this.parties;
        this.trip.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int dowait(boolean bl2, long l2) throws InterruptedException, BrokenBarrierException, TimeoutException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2;
            Generation generation = this.generation;
            if (generation.broken) {
                throw new BrokenBarrierException();
            }
            if (Thread.interrupted()) {
                this.breakBarrier();
                throw new InterruptedException();
            }
            if ((n2 = --this.count) == 0) {
                boolean bl3 = false;
                try {
                    Runnable runnable = this.barrierCommand;
                    if (runnable != null) {
                        runnable.run();
                    }
                    bl3 = true;
                    this.nextGeneration();
                    int n3 = 0;
                    return n3;
                }
                finally {
                    if (!bl3) {
                        this.breakBarrier();
                    }
                }
            }
            do {
                block19: {
                    try {
                        if (!bl2) {
                            this.trip.await();
                            break block19;
                        }
                        if (l2 > 0L) {
                            l2 = this.trip.awaitNanos(l2);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.breakBarrier();
                        throw interruptedException;
                    }
                }
                if (generation.broken) {
                    throw new BrokenBarrierException();
                }
                if (!generation.tripped) continue;
                int n4 = n2;
                return n4;
            } while (!bl2 || l2 > 0L);
            this.breakBarrier();
            throw new TimeoutException();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public CyclicBarrier(int n2, Runnable runnable) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties = n2;
        this.count = n2;
        this.barrierCommand = runnable;
    }

    public CyclicBarrier(int n2) {
        this(n2, null);
    }

    public int getParties() {
        return this.parties;
    }

    public int await() throws InterruptedException, BrokenBarrierException {
        try {
            return this.dowait(false, 0L);
        }
        catch (TimeoutException timeoutException) {
            throw new Error(timeoutException);
        }
    }

    public int await(long l2, TimeUnit timeUnit) throws InterruptedException, BrokenBarrierException, TimeoutException {
        return this.dowait(true, timeUnit.toNanos(l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBroken() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = this.generation.broken;
            return bl2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.breakBarrier();
            this.nextGeneration();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberWaiting() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2 = this.parties - this.count;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private static class Generation {
        boolean broken = false;
        boolean tripped = false;

        private Generation() {
        }
    }
}

