/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.ejb.mdb;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.monitor.factory.CreateLogOutputInfo;
import com.clustercontrol.monitor.factory.OutputEventLog;
import com.clustercontrol.monitor.factory.OutputStatusInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.monitor.util.SendMail;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyInfoContext;
import com.clustercontrol.notify.factory.SelectNotify;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogOutputBean
implements MessageDrivenBean,
MessageListener {
    protected static Log m_log = LogFactory.getLog(LogOutputBean.class);
    private static SendMail m_sender = new SendMail();
    private static HashMap<String, NotifyInfo> m_notifyMap = null;
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    public void onMessage(Message message) {
        block17: {
            m_log.debug((Object)("Message Driven Bean got message " + message));
            if (m_notifyMap == null) {
                try {
                    m_notifyMap = new SelectNotify().getNotifyMap();
                }
                catch (Exception e) {
                    m_log.error((Object)("onMessage(): \u901a\u77e5\u60c5\u5831\u30ad\u30e3\u30c3\u30b7\u30e5\u53d6\u5f97\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 " + e.getMessage()));
                }
            }
            if (message instanceof ObjectMessage) {
                ObjectMessage msg = (ObjectMessage)message;
                try {
                    Serializable objMsg = msg.getObject();
                    if (objMsg instanceof LogOutputInfo) {
                        LogOutputInfo info = (LogOutputInfo)objMsg;
                        this.outputLog(info);
                        break block17;
                    }
                    if (objMsg instanceof LogOutputNotifyInfo) {
                        NotifyInfo notifyInfo;
                        String notifyId;
                        LogOutputNotifyInfo basicInfo = (LogOutputNotifyInfo)objMsg;
                        if (basicInfo != null && (notifyId = basicInfo.getNotifyId()) != null && !"".equals(notifyId.trim()) && (notifyInfo = m_notifyMap.get(notifyId)) != null) {
                            LogOutputInfo info = new CreateLogOutputInfo().get(notifyInfo, basicInfo);
                            this.outputLog(info);
                        }
                        break block17;
                    }
                    if (objMsg instanceof NotifyInfoContext) {
                        try {
                            NotifyInfoContext notifyInfoContext = (NotifyInfoContext)objMsg;
                            if (0 == notifyInfoContext.getType() || 1 == notifyInfoContext.getType()) {
                                m_notifyMap.put(notifyInfoContext.getNotifyId(), notifyInfoContext.getNotifyInfo());
                            } else if (2 == notifyInfoContext.getType()) {
                                m_notifyMap.remove(notifyInfoContext.getNotifyId());
                            }
                            break block17;
                        }
                        catch (Exception e) {
                            m_log.error((Object)("onMessage(): \u901a\u77e5\u60c5\u5831\u30ad\u30e3\u30c3\u30b7\u30e5\u66f4\u65b0\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + e.getMessage()));
                        }
                        break block17;
                    }
                    m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + objMsg.toString()));
                }
                catch (JMSException e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()));
                }
                catch (EJBException e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()));
                }
                catch (Exception e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()));
                }
            }
        }
    }

    public void outputLog(LogOutputInfo logOutput) {
        AccessLock.lock((String)"MONITOR");
        Date now = new Date();
        Timestamp outputDate = new Timestamp(now.getTime());
        boolean reuslt = false;
        OutputEventLog eventLog = new OutputEventLog();
        reuslt = eventLog.outputEventLog(logOutput, outputDate);
        OutputStatusInfo statusInfo = new OutputStatusInfo();
        reuslt = statusInfo.outputStatusInfo(logOutput, eventLog.getOutputDate());
        if (eventLog.isInsertFlg()) {
            reuslt = m_sender.sendMail(logOutput.getAddress(), logOutput, eventLog.getOutputDate());
        }
    }
}

