/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.EventLogPK;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyEventConfirm {
    private static final int CONFIRM_NUM_FOR_COMMIT = 1000;
    protected static Log m_log = LogFactory.getLog(ModifyEventConfirm.class);

    public void modifyConfirm(List list, int confirmType) throws NamingException, FinderException {
        if (list != null && list.size() > 0) {
            Date confirmDate = null;
            if (confirmType == 1) {
                confirmDate = new Date();
            }
            ArrayList info = null;
            for (int index = 0; index < list.size(); ++index) {
                info = (ArrayList)list.get(index);
                if (info == null || info.size() <= 0) continue;
                this.modifyConfirm((String)info.get(4), (String)info.get(3), (String)info.get(5), (Date)info.get(1), confirmDate, confirmType);
            }
        }
    }

    public void modifyConfirm(String monitorId, String pluginId, String facilityId, Date outputDate, Date confirmDate, int confirmType) throws NamingException, FinderException {
        try {
            EventLogPK pk = new EventLogPK(monitorId, pluginId, facilityId, new Timestamp(outputDate.getTime()));
            EventLogLocal event = EventLogUtil.getLocalHome().findByPrimaryKey(pk);
            event.setConfirmFlg(new Integer(confirmType));
            if (confirmType == 1) {
                if (confirmDate == null) {
                    confirmDate = new Date();
                }
                event.setConfirmDate(new Timestamp(confirmDate.getTime()));
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, monitorId, pluginId, ConfirmConstant.typeToString((int)confirmType)};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("modifyConfirm():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, monitorId, pluginId, ConfirmConstant.typeToString((int)confirmType)};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("modifyConfirm():" + e.getMessage()));
            throw e;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyBatchConfirm(int confirmType, String facilityId, Property property) throws CreateException, NamingException, FinderException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, Exception {
        Iterator itr;
        Transaction oldTx;
        Transaction tx;
        TransactionManager tm;
        String message;
        String application;
        String facilityType;
        Timestamp generationToDate;
        Timestamp generationFromDate;
        Timestamp outputToDate;
        Timestamp outputFromDate;
        Integer priority;
        block42: {
            int priorityType;
            ArrayList values = null;
            priority = null;
            outputFromDate = null;
            outputToDate = null;
            generationFromDate = null;
            generationToDate = null;
            facilityType = null;
            application = null;
            message = null;
            tm = null;
            tx = null;
            oldTx = null;
            values = PropertyUtil.getPropertyValue((Property)property, (String)"priority");
            if (!"".equals((String)values.get(0)) && (priorityType = PriorityConstant.stringToType((String)((String)values.get(0)))) != -1) {
                priority = new Integer(priorityType);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputFromDate")).get(0) instanceof Date) {
                outputFromDate = new Timestamp(((Date)values.get(0)).getTime());
                outputFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputToDate")).get(0) instanceof Date) {
                outputToDate = new Timestamp(((Date)values.get(0)).getTime());
                outputToDate.setNanos(999999999);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationFromDate")).get(0) instanceof Date) {
                generationFromDate = new Timestamp(((Date)values.get(0)).getTime());
                generationFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationToDate")).get(0) instanceof Date) {
                generationToDate = new Timestamp(((Date)values.get(0)).getTime());
                generationToDate.setNanos(999999999);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityType")).get(0))) {
                facilityType = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"application")).get(0))) {
                application = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"message")).get(0))) {
                message = (String)values.get(0);
            }
            String[] facilityIds = null;
            if (facilityId != null && !"".equals(facilityId)) {
                ArrayList facilityIdList;
                int level = 0;
                if (FacilityTargetConstant.STRING_BENEATH.equals(facilityType)) {
                    level = 1;
                }
                if ((facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level)) != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else {
                    facilityIds = new String[]{facilityId};
                }
            }
            Integer selectConfirmFlg = null;
            if (confirmType == 1) {
                selectConfirmFlg = new Integer(0);
            } else if (confirmType == 0) {
                selectConfirmFlg = new Integer(1);
            }
            Collection ct = EventLogUtil.getLocalHome().selectEvent(facilityIds, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, selectConfirmFlg);
            itr = ct.iterator();
            if (itr.hasNext()) break block42;
            if (oldTx == null) return;
            try {
                tm.resume(oldTx);
                return;
            }
            catch (Exception e) {
                this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
                m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
                throw e;
            }
        }
        boolean transactionErrorFlag = false;
        InitialContext context = new InitialContext();
        tm = (TransactionManager)context.lookup("java:/TransactionManager");
        if (tm.getTransaction() != null) {
            oldTx = tm.suspend();
        }
        Integer confirmFlg = new Integer(confirmType);
        Timestamp now = new Timestamp(new Date().getTime());
        try {
            int count = 0;
            while (itr.hasNext()) {
                ++count;
                if (tm.getTransaction() == null) {
                    tm.begin();
                    tx = tm.getTransaction();
                }
                EventLogLocal event = (EventLogLocal)itr.next();
                event.setConfirmFlg(confirmFlg);
                if (confirmType == 1) {
                    event.setConfirmDate(now);
                }
                if (count % 1000 != 0 && itr.hasNext()) continue;
                tx.commit();
            }
        }
        catch (NotSupportedException e) {
            transactionErrorFlag = true;
            this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
            m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
            throw e;
        }
        catch (RollbackException e) {
            transactionErrorFlag = true;
            this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
            m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
            throw e;
        }
        catch (HeuristicMixedException e) {
            transactionErrorFlag = true;
            this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
            m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
            throw e;
        }
        catch (HeuristicRollbackException e) {
            transactionErrorFlag = true;
            this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
            m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
            throw e;
        }
        catch (SystemException e) {
            transactionErrorFlag = true;
            this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
            m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
            throw e;
        }
        finally {
            if (transactionErrorFlag && tx != null) {
                tx.rollback();
            }
        }
        if (oldTx == null) return;
        try {
            tm.resume(oldTx);
            return;
        }
        catch (Exception e) {
            this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
            m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            try {
                this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
                m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
                throw e;
                catch (FinderException e2) {
                    this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
                    m_log.debug((Object)("modifyBatchConfirm():" + e2.getMessage()));
                    throw e2;
                }
                catch (NamingException e3) {
                    this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
                    m_log.debug((Object)("modifyBatchConfirm():" + e3.getMessage()));
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                if (oldTx == null) throw throwable;
                try {
                    tm.resume(oldTx);
                    throw throwable;
                }
                catch (Exception e4) {
                    this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
                    m_log.debug((Object)("modifyBatchConfirm():" + e4.getMessage()));
                    throw e4;
                }
            }
        }
    }

    private void setAplLogForBatchConfirmFailure(String facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String facilityType, String application, String message, int confirmType) {
        int priorityInt = -1;
        String outputFromDateString = null;
        String outputToDateString = null;
        String generationFromDateString = null;
        String generationToDateString = null;
        if (priority != null) {
            priorityInt = priority;
        }
        if (outputFromDate != null) {
            outputFromDateString = outputFromDate.toString();
        }
        if (outputToDate != null) {
            outputToDateString = outputToDate.toString();
        }
        if (generationFromDate != null) {
            generationFromDateString = generationFromDate.toString();
        }
        if (generationToDate != null) {
            generationToDateString = generationToDate.toString();
        }
        AplLogger apllog = new AplLogger("MON", "mon");
        Object[] args = new String[]{facilityId, PriorityConstant.typeToString((int)priorityInt), outputFromDateString, outputToDateString, generationFromDateString, generationToDateString, facilityType, application, message, ConfirmConstant.typeToString((int)confirmType)};
        apllog.put("SYS", "005", args);
    }
}

