/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectStatus {
    protected static Log m_log = LogFactory.getLog(SelectStatus.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getStatusList(String facilityId, int level) throws CreateException, FinderException, NamingException {
        ArrayList list = null;
        try {
            String[] facilityIds = null;
            if (level == -1) {
                if (facilityId == null) return null;
                if ("".equals(facilityId)) return null;
                facilityIds = new String[]{facilityId};
            } else {
                ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
                if (facilityIdList != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else {
                    if (facilityId == null) return null;
                    facilityIds = new String[]{facilityId};
                }
            }
            Collection ct = StatusInfoUtil.getLocalHome().selectStatus(facilityIds, null, null, null, null, null, null, null);
            return this.collectionToArray(facilityId, ct);
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, null, null, null, null, null, null, null, null};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("getStatusList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, null, null, null, null, null, null, null, null};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("getStatusList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, null, null, null, null, null, null, null, null};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("getStatusList():" + e.getMessage()));
            throw e;
        }
    }

    public ArrayList getStatusList(String facilityId, Property property) throws CreateException, FinderException, NamingException {
        ArrayList list = null;
        Integer priority = null;
        Timestamp outputFromDate = null;
        Timestamp outputToDate = null;
        Timestamp generationFromDate = null;
        Timestamp generationToDate = null;
        String facilityType = null;
        String application = null;
        String message = null;
        try {
            int priorityType;
            ArrayList values = null;
            values = PropertyUtil.getPropertyValue((Property)property, (String)"priority");
            if (!"".equals((String)values.get(0)) && (priorityType = PriorityConstant.stringToType((String)((String)values.get(0)))) != -1) {
                priority = new Integer(priorityType);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputFromDate")).get(0) instanceof Date) {
                outputFromDate = new Timestamp(((Date)values.get(0)).getTime());
                outputFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputToDate")).get(0) instanceof Date) {
                outputToDate = new Timestamp(((Date)values.get(0)).getTime());
                outputToDate.setNanos(999999999);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationFromDate")).get(0) instanceof Date) {
                generationFromDate = new Timestamp(((Date)values.get(0)).getTime());
                generationFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationToDate")).get(0) instanceof Date) {
                generationToDate = new Timestamp(((Date)values.get(0)).getTime());
                generationToDate.setNanos(999999999);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityType")).get(0))) {
                facilityType = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"application")).get(0))) {
                application = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"message")).get(0))) {
                message = (String)values.get(0);
            }
            int level = 0;
            if (FacilityTargetConstant.STRING_BENEATH.equals(facilityType)) {
                level = 1;
            }
            ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
            String[] facilityIds = null;
            if (facilityIdList != null && facilityIdList.size() > 0) {
                facilityIds = new String[facilityIdList.size()];
                facilityIdList.toArray(facilityIds);
            } else if (facilityId != null) {
                facilityIds = new String[]{facilityId};
            } else {
                return null;
            }
            Collection ct = StatusInfoUtil.getLocalHome().selectStatus(facilityIds, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message);
            list = this.collectionToArray(facilityId, ct);
        }
        catch (CreateException e) {
            int priorityInt = -1;
            String outputFromDateString = null;
            String outputToDateString = null;
            String generationFromDateString = null;
            String generationToDateString = null;
            if (priority != null) {
                priorityInt = priority;
            }
            if (outputFromDate != null) {
                outputFromDateString = outputFromDate.toString();
            }
            if (outputToDate != null) {
                outputToDateString = outputToDate.toString();
            }
            if (generationFromDate != null) {
                generationFromDateString = generationFromDate.toString();
            }
            if (generationToDate != null) {
                generationToDateString = generationToDate.toString();
            }
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, PriorityConstant.typeToString((int)priorityInt), outputFromDateString, outputToDateString, generationFromDateString, generationToDateString, facilityType, application, message};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("getStatusList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            int priorityInt = -1;
            String outputFromDateString = null;
            String outputToDateString = null;
            String generationFromDateString = null;
            String generationToDateString = null;
            if (priority != null) {
                priorityInt = priority;
            }
            if (outputFromDate != null) {
                outputFromDateString = outputFromDate.toString();
            }
            if (outputToDate != null) {
                outputToDateString = outputToDate.toString();
            }
            if (generationFromDate != null) {
                generationFromDateString = generationFromDate.toString();
            }
            if (generationToDate != null) {
                generationToDateString = generationToDate.toString();
            }
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, PriorityConstant.typeToString((int)priorityInt), outputFromDateString, outputToDateString, generationFromDateString, generationToDateString, facilityType, application, message};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("getStatusList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            int priorityInt = -1;
            String outputFromDateString = null;
            String outputToDateString = null;
            String generationFromDateString = null;
            String generationToDateString = null;
            if (priority != null) {
                priorityInt = priority;
            }
            if (outputFromDate != null) {
                outputFromDateString = outputFromDate.toString();
            }
            if (outputToDate != null) {
                outputToDateString = outputToDate.toString();
            }
            if (generationFromDate != null) {
                generationFromDateString = generationFromDate.toString();
            }
            if (generationToDate != null) {
                generationToDateString = generationToDate.toString();
            }
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, PriorityConstant.typeToString((int)priorityInt), outputFromDateString, outputToDateString, generationFromDateString, generationToDateString, facilityType, application, message};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("getStatusList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StatusInfoLocal getHighPriorityStatus(String facilityId, int level) throws CreateException, FinderException, NamingException {
        StatusInfoLocal status = null;
        try {
            String[] facilityIds = null;
            if (level == -1) {
                if (facilityId == null) return null;
                if ("".equals(facilityId)) return null;
                facilityIds = new String[]{facilityId};
            } else {
                ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
                if (facilityIdList != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else {
                    if (facilityId == null) return null;
                    facilityIds = new String[]{facilityId};
                }
            }
            Collection ct = StatusInfoUtil.getLocalHome().selectHighPriorityStatus(facilityIds, null, null, null, null, null, null);
            Iterator itr = ct.iterator();
            if (!itr.hasNext()) return status;
            return (StatusInfoLocal)itr.next();
        }
        catch (CreateException e) {
            m_log.debug((Object)("getHighPriorityStatus():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("getHighPriorityStatus():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("getHighPriorityStatus():" + e.getMessage()));
            throw e;
        }
    }

    private ArrayList collectionToArray(String parentFacilityId, Collection ct) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        ArrayList list = new ArrayList();
        for (StatusInfoLocal status : ct) {
            String facilityPath = repository.getFacilityPath(status.getFacilityId(), parentFacilityId);
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(status.getPriority());
            info.add(status.getPluginId());
            info.add(status.getMonitorId());
            info.add(status.getFacilityId());
            info.add(facilityPath);
            info.add(status.getApplication());
            info.add(new Date(status.getOutputDate().getTime()));
            info.add(new Date(status.getGenerationDate().getTime()));
            info.add(status.getMessageId());
            info.add(status.getMessage());
            list.add(info);
        }
        return list;
    }
}

