/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.composite.CommonTableContentProvider;
import com.clustercontrol.composite.CommonTableLabelProvider;
import com.clustercontrol.composite.CommonTableViewerSorter;
import com.clustercontrol.composite.ICommonTableLabelProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CommonTableViewer
extends TableViewer {
    protected ArrayList m_tableColumnList = null;
    protected boolean m_sortType = true;

    public CommonTableViewer(Composite parent) {
        super(parent);
        this.setLabelProvider((IBaseLabelProvider)new CommonTableLabelProvider(this));
        this.setContentProvider((IContentProvider)new CommonTableContentProvider());
    }

    public CommonTableViewer(Composite parent, int style) {
        super(parent, style);
        this.setLabelProvider((IBaseLabelProvider)new CommonTableLabelProvider(this));
        this.setContentProvider((IContentProvider)new CommonTableContentProvider());
    }

    public CommonTableViewer(Table table) {
        super(table);
        this.setLabelProvider((IBaseLabelProvider)new CommonTableLabelProvider(this));
        this.setContentProvider((IContentProvider)new CommonTableContentProvider());
    }

    public void createTableColumn(ArrayList tableColumnList, int sortColumnIndex, int sortOrder) {
        this.m_tableColumnList = tableColumnList;
        int i = 0;
        while (i < this.m_tableColumnList.size()) {
            TableColumnInfo tableColumnInfo = (TableColumnInfo)this.m_tableColumnList.get(i);
            TableColumn column = new TableColumn(this.getTable(), tableColumnInfo.getStyle(), i);
            column.setText(tableColumnInfo.getName());
            column.setWidth(tableColumnInfo.getWidth());
            if (i == sortColumnIndex) {
                int order = sortOrder;
                tableColumnInfo.setOrder(order);
                this.setSorter(new CommonTableViewerSorter(i, order));
            }
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn column = (TableColumn)e.getSource();
                    ArrayList tableColumnList = CommonTableViewer.this.getTableColumnList();
                    int i = 0;
                    while (i < tableColumnList.size()) {
                        TableColumnInfo tableColumnInfo = (TableColumnInfo)tableColumnList.get(i);
                        if (tableColumnInfo.getName().compareTo(column.getText()) == 0) {
                            int order = tableColumnInfo.getOrder() * -1;
                            tableColumnInfo.setOrder(order);
                            CommonTableViewer.this.setSorter(new CommonTableViewerSorter(i, order));
                            break;
                        }
                        ++i;
                    }
                }
            });
            ++i;
        }
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            if (fullMap) {
                this.associate(element, (Item)item);
            } else {
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            IBaseLabelProvider prov = this.getLabelProvider();
            ICommonTableLabelProvider tprov = null;
            if (prov instanceof ICommonTableLabelProvider) {
                tprov = (ICommonTableLabelProvider)prov;
                int columnCount = super.getTable().getColumnCount();
                TableItem ti = item;
                int column = 0;
                while (column < columnCount || column == 0) {
                    String text = "";
                    Image image = null;
                    Color color = null;
                    if (tprov != null) {
                        text = tprov.getColumnText(element, column);
                        image = tprov.getColumnImage(element, column);
                        color = tprov.getColumnColor(element, column);
                    }
                    ti.setText(column, text);
                    if (ti.getImage(column) != image) {
                        ti.setImage(column, image);
                    }
                    if (color != null) {
                        ti.setBackground(column, color);
                    }
                    ++column;
                }
                if (prov instanceof IColorProvider) {
                    IColorProvider cprov = (IColorProvider)prov;
                    ti.setForeground(cprov.getForeground(element));
                    ti.setBackground(cprov.getBackground(element));
                }
                if (prov instanceof IFontProvider) {
                    IFontProvider fprov = (IFontProvider)prov;
                    ti.setFont(fprov.getFont(element));
                }
            } else {
                super.doUpdateItem(widget, element, fullMap);
            }
        }
    }

    public ArrayList getTableColumnList() {
        return this.m_tableColumnList;
    }

    public int getTableColumnIndex(int type) {
        int index = -1;
        int i = 0;
        while (i < this.m_tableColumnList.size()) {
            TableColumnInfo tableColumn = (TableColumnInfo)this.m_tableColumnList.get(i);
            if (type == tableColumn.getType()) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }
}

