/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.vafada.swtcalendar.SWTCalendar;

public class DateTimeDialog
extends CommonDialog {
    protected SWTCalendar swtcal = null;
    protected Date dateBefore;
    protected Date date;
    protected Combo comboHours = null;
    protected Combo comboMinutes = null;
    protected Combo comboSecond = null;

    public DateTimeDialog(Shell parent) {
        super(parent);
    }

    protected void customizeDialog(Composite composite) {
        composite.getShell().setText(Messages.getString((String)"time"));
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        this.swtcal = new SWTCalendar(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.swtcal.setLayoutData(gridData);
        Composite timeComposite = new Composite(composite, 0);
        gridLayout = new GridLayout(5, false);
        timeComposite.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        Label labelTime = new Label(timeComposite, 0);
        labelTime.setText(Messages.getString((String)"timestamp"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 5;
        labelTime.setLayoutData((Object)gridData);
        this.comboHours = new Combo(timeComposite, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboHours.setLayoutData((Object)gridData);
        this.comboHours.setTextLimit(2);
        this.comboHours.setVisibleItemCount(10);
        DecimalFormat format = new DecimalFormat("00");
        int hour = 0;
        while (hour < 24) {
            this.comboHours.add(format.format(hour));
            ++hour;
        }
        Label labelHours = new Label(timeComposite, 0);
        labelHours.setText(Messages.getString((String)":"));
        this.comboMinutes = new Combo(timeComposite, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.comboMinutes.setLayoutData((Object)gridData);
        this.comboMinutes.setTextLimit(2);
        this.comboMinutes.setVisibleItemCount(10);
        int minutes = 0;
        while (minutes < 60) {
            this.comboMinutes.add(format.format(minutes));
            ++minutes;
        }
        Label labelMinutes = new Label(timeComposite, 0);
        labelMinutes.setText(Messages.getString((String)":"));
        this.comboSecond = new Combo(timeComposite, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboSecond.setLayoutData((Object)gridData);
        this.comboSecond.setTextLimit(2);
        this.comboSecond.setVisibleItemCount(10);
        int second = 0;
        while (second < 60) {
            this.comboSecond.add(format.format(second));
            ++second;
        }
        if (this.dateBefore != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.dateBefore);
            this.swtcal.setCalendar(calendar);
            this.comboHours.setText(format.format(calendar.get(11)));
            this.comboMinutes.setText(format.format(calendar.get(12)));
            this.comboSecond.setText(format.format(calendar.get(13)));
        } else {
            Calendar calendar = Calendar.getInstance();
            this.comboHours.setText(format.format(calendar.get(11)));
            this.comboMinutes.setText(format.format(calendar.get(12)));
            this.comboSecond.setText(format.format(calendar.get(13)));
        }
    }

    public void setDate(Date date) {
        this.dateBefore = date;
    }

    public Date getDate() {
        return this.date;
    }

    protected void cancelPressed() {
        this.date = this.dateBefore;
        super.cancelPressed();
    }

    protected void okPressed() {
        this.date = this.swtcal.getCalendar().getTime();
        Integer hours = new Integer(this.comboHours.getText());
        Integer minutes = new Integer(this.comboMinutes.getText());
        Integer second = new Integer(this.comboSecond.getText());
        Calendar work = Calendar.getInstance();
        work.setTime(this.date);
        work.set(11, hours);
        work.set(12, minutes);
        work.set(13, second);
        work.set(14, 0);
        this.date = work.getTime();
        super.okPressed();
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        Calendar work = Calendar.getInstance();
        work.setTime(this.date);
        work.getTime();
        Calendar startDate = Calendar.getInstance();
        startDate.set(1, 1970);
        startDate.set(2, 0);
        startDate.set(5, 1);
        startDate.set(11, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        startDate.getTime();
        Calendar endDate = Calendar.getInstance();
        endDate.set(1, 2199);
        endDate.set(2, 11);
        endDate.set(5, 31);
        endDate.set(11, 23);
        endDate.set(12, 59);
        endDate.set(13, 59);
        endDate.set(14, 999);
        endDate.getTime();
        if (work.after(startDate) && work.before(endDate)) {
            result = null;
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            DateFormat format = DateFormat.getDateTimeInstance();
            Object[] args1 = new String[]{format.format(startDate.getTime()), format.format(endDate.getTime())};
            result.setMessage(Messages.getString((String)"message.hinemos.4", (Object[])args1));
        }
        return result;
    }
}

