#!/bin/sh

#Copyright (C) 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

EXEC_PATH=${0%/*}

echo "###################################################################"
echo "###                                                             ###"
echo "### 運用管理ソフトウェア Hinemos  クライアント                  ###"
echo "###                                   インストーラ   Ver 2.0    ###"
echo "###                                                             ###"
echo "###  2006/3/31                                                  ###"
echo "###  Copyright (C) 2006 NTT DATA Corporation.                   ###"
echo "###################################################################"


#設定情報読み込み
. ${0%/*}/install.cfg

while [ 1 ];
do
	echo "Hinemos クライアント の"
	echo "     1) インストール"
	echo "     9) インストーラの終了"
	echo ""
	echo -n "===> "
	
	read CHOSEN_NUMBER

	case ${CHOSEN_NUMBER} in
	1)
		echo ""
	
		while [ 1 ];
		do
			echo ""
			echo "インストールを開始します。よろしいですか?(Y/N)"
			read ANS
			case ${ANS} in
				y|Y)
					# インストール準備部分
					echo "Hinemos クライアントをインストールするディレクトリは /opt/hinemos_client です。"
					echo "rootユーザ以外でインストールしている場合は、書き込み権限を与えて下さい。"
					
					if [ ! -d ${HINEMOS_CLIENT_HOME} ]; then
					    echo "${HINEMOS_CLIENT_HOME}は存在しません。作成します。"
					    mkdir -p ${HINEMOS_CLIENT_HOME}
					   if [ $? -ne 0 ] ; then
    					       exit 2
 					   fi
					   echo ""
					fi
	
					# クライアント該当部分をコピーする。
					echo "必要なファイルのコピーを行なっています。"
					cp -pr ${EXEC_PATH}/hinemos_client/* ${HINEMOS_CLIENT_HOME}
					echo "必要なファイルのコピーが終わりました。"




















					

					#起動スクリプト設定
#					sed -e "s%\%\%HinemosHome\%\%%${HINEMOS_CLIENT_HOME}%" -e "s/%%ClientJRE%%/${JRE_NAME}/" $EXEC_PATH/scripts/hinemos_client.sh > ${HINEMOS_CLIENT_HOME}/hinemos_client.sh
#					chmod +x ${HINEMOS_CLIENT_HOME}/hinemos_client.sh
					echo ""	
					echo ""	
					echo "Hinemos クライアントのインストールが完了しました。"
					echo "${HINEMOS_CLIENT_HOME}/hinemos_client.sh でHinemosクライアントが起動します。"	
					echo ""	
					echo ""	
					break
					;;

				n|N)
					echo "インストールを中止してメニューに戻ります。"
					echo ""
					sleep 1
					break
					;;

			    *)
				;;
			esac

		done
		;;
	9)
		echo "Hinemos インストーラを終了します。"
		exit
		;;
	*)
		echo ""
		sleep 1
		;;
  esac
done
