/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.CommandComposite;
import com.clustercontrol.jobmanagement.composite.ControlComposite;
import com.clustercontrol.jobmanagement.composite.EndDelayComposite;
import com.clustercontrol.jobmanagement.composite.EndStatusComposite;
import com.clustercontrol.jobmanagement.composite.FileComposite;
import com.clustercontrol.jobmanagement.composite.NotificationsComposite;
import com.clustercontrol.jobmanagement.composite.ParameterComposite;
import com.clustercontrol.jobmanagement.composite.StartDelayComposite;
import com.clustercontrol.jobmanagement.composite.WaitRuleComposite;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class JobDialog
extends CommonDialog {
    protected Text m_jobIdText = null;
    protected Text m_jobNameText = null;
    protected Text m_jobAnnotationText = null;
    protected WaitRuleComposite m_startComposite = null;
    protected ControlComposite m_controlComposite = null;
    protected EndStatusComposite m_endComposite = null;
    protected CommandComposite m_executeComposite = null;
    protected FileComposite m_fileComposite = null;
    protected NotificationsComposite m_messageComposite = null;
    protected StartDelayComposite m_startDelayComposite = null;
    protected EndDelayComposite m_endDelayComposite = null;
    protected ParameterComposite m_parameterComposite = null;
    protected JobTreeItem m_jobTreeItem = null;
    protected TabFolder m_tabFolder = null;
    protected Shell m_shell = null;
    protected boolean m_readOnly = false;

    public JobDialog(Shell parent, boolean readOnly) {
        super(parent);
        this.m_readOnly = readOnly;
    }

    protected void customizeDialog(Composite parent) {
        this.m_shell = this.getShell();
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        parent.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        JobInfo info = this.m_jobTreeItem.getData();
        if (info instanceof JobInfo) {
            if (info.getType() == 0) {
                parent.getShell().setText(Messages.getString((String)"dialog.job.create.modify.jobunit"));
            } else if (info.getType() == 1) {
                parent.getShell().setText(Messages.getString((String)"dialog.job.create.modify.jobnet"));
            } else if (info.getType() == 2) {
                parent.getShell().setText(Messages.getString((String)"dialog.job.create.modify.job"));
            } else if (info.getType() == 3) {
                parent.getShell().setText(Messages.getString((String)"dialog.job.create.modify.forward.file.job"));
            }
        }
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label jobIdTitle = new Label(composite, 0);
        jobIdTitle.setText(String.valueOf(Messages.getString((String)"job.id")) + " : ");
        jobIdTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_jobIdText = new Text(composite, 2048);
        this.m_jobIdText.setLayoutData((Object)new RowData(150, 15));
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label jobNameTitle = new Label(composite, 0);
        jobNameTitle.setText(String.valueOf(Messages.getString((String)"job.name")) + " : ");
        jobNameTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_jobNameText = new Text(composite, 2048);
        this.m_jobNameText.setLayoutData((Object)new RowData(150, 15));
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label jobAnnotationTitle = new Label(composite, 0);
        jobAnnotationTitle.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        jobAnnotationTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_jobAnnotationText = new Text(composite, 2048);
        this.m_jobAnnotationText.setLayoutData((Object)new RowData(150, 15));
        this.m_tabFolder = new TabFolder(parent, 0);
        if (info instanceof JobInfo) {
            TabItem tabItem3;
            TabItem tabItem2;
            TabItem tabItem1;
            if (info.getType() == 1) {
                this.m_startComposite = new WaitRuleComposite((Composite)this.m_tabFolder, 0);
                tabItem1 = new TabItem(this.m_tabFolder, 0);
                tabItem1.setText(Messages.getString((String)"wait.rule"));
                tabItem1.setControl((Control)this.m_startComposite);
                this.m_controlComposite = new ControlComposite((Composite)this.m_tabFolder, 0);
                tabItem2 = new TabItem(this.m_tabFolder, 0);
                tabItem2.setText(Messages.getString((String)"control"));
                tabItem2.setControl((Control)this.m_controlComposite);
                this.m_startDelayComposite = new StartDelayComposite((Composite)this.m_tabFolder, 0);
                tabItem3 = new TabItem(this.m_tabFolder, 0);
                tabItem3.setText(Messages.getString((String)"start.delay"));
                tabItem3.setControl((Control)this.m_startDelayComposite);
                this.m_endDelayComposite = new EndDelayComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem4 = new TabItem(this.m_tabFolder, 0);
                tabItem4.setText(Messages.getString((String)"end.delay"));
                tabItem4.setControl((Control)this.m_endDelayComposite);
            } else if (info.getType() == 2) {
                this.m_startComposite = new WaitRuleComposite((Composite)this.m_tabFolder, 0);
                tabItem1 = new TabItem(this.m_tabFolder, 0);
                tabItem1.setText(Messages.getString((String)"wait.rule"));
                tabItem1.setControl((Control)this.m_startComposite);
                this.m_controlComposite = new ControlComposite((Composite)this.m_tabFolder, 0);
                tabItem2 = new TabItem(this.m_tabFolder, 0);
                tabItem2.setText(Messages.getString((String)"control"));
                tabItem2.setControl((Control)this.m_controlComposite);
                this.m_executeComposite = new CommandComposite((Composite)this.m_tabFolder, 0);
                tabItem3 = new TabItem(this.m_tabFolder, 0);
                tabItem3.setText(Messages.getString((String)"command"));
                tabItem3.setControl((Control)this.m_executeComposite);
                this.m_startDelayComposite = new StartDelayComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem4 = new TabItem(this.m_tabFolder, 0);
                tabItem4.setText(Messages.getString((String)"start.delay"));
                tabItem4.setControl((Control)this.m_startDelayComposite);
                this.m_endDelayComposite = new EndDelayComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem5 = new TabItem(this.m_tabFolder, 0);
                tabItem5.setText(Messages.getString((String)"end.delay"));
                tabItem5.setControl((Control)this.m_endDelayComposite);
            } else if (info.getType() == 3) {
                this.m_startComposite = new WaitRuleComposite((Composite)this.m_tabFolder, 0);
                tabItem1 = new TabItem(this.m_tabFolder, 0);
                tabItem1.setText(Messages.getString((String)"wait.rule"));
                tabItem1.setControl((Control)this.m_startComposite);
                this.m_controlComposite = new ControlComposite((Composite)this.m_tabFolder, 0);
                tabItem2 = new TabItem(this.m_tabFolder, 0);
                tabItem2.setText(Messages.getString((String)"control"));
                tabItem2.setControl((Control)this.m_controlComposite);
                this.m_fileComposite = new FileComposite((Composite)this.m_tabFolder, 0);
                tabItem3 = new TabItem(this.m_tabFolder, 0);
                tabItem3.setText(Messages.getString((String)"forward.file"));
                tabItem3.setControl((Control)this.m_fileComposite);
                this.m_startDelayComposite = new StartDelayComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem4 = new TabItem(this.m_tabFolder, 0);
                tabItem4.setText(Messages.getString((String)"start.delay"));
                tabItem4.setControl((Control)this.m_startDelayComposite);
                this.m_endDelayComposite = new EndDelayComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem5 = new TabItem(this.m_tabFolder, 0);
                tabItem5.setText(Messages.getString((String)"end.delay"));
                tabItem5.setControl((Control)this.m_endDelayComposite);
            }
            this.m_endComposite = new EndStatusComposite((Composite)this.m_tabFolder, 0);
            TabItem tabItem6 = new TabItem(this.m_tabFolder, 0);
            tabItem6.setText(Messages.getString((String)"end.status"));
            tabItem6.setControl((Control)this.m_endComposite);
            this.m_messageComposite = new NotificationsComposite((Composite)this.m_tabFolder, 0);
            TabItem tabItem7 = new TabItem(this.m_tabFolder, 0);
            tabItem7.setText(Messages.getString((String)"notifications"));
            tabItem7.setControl((Control)this.m_messageComposite);
            if (info.getType() == 0 || info.getParam() instanceof ArrayList && info.getParam().size() > 0) {
                this.m_parameterComposite = new ParameterComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem8 = new TabItem(this.m_tabFolder, 0);
                tabItem8.setText(Messages.getString((String)"job.parameter"));
                tabItem8.setControl((Control)this.m_parameterComposite);
            }
        }
        this.m_tabFolder.setSelection(0);
        new Label(parent, 258);
        Display display = this.m_shell.getDisplay();
        this.m_shell.setLocation((display.getBounds().width - this.m_shell.getSize().x) / 2, (display.getBounds().height - this.m_shell.getSize().y) / 2);
        this.reflectJobInfo();
        if (this.m_readOnly) {
            this.m_jobIdText.setEnabled(false);
            this.m_jobNameText.setEnabled(false);
            this.m_jobAnnotationText.setEnabled(false);
            if (this.m_startComposite != null) {
                this.m_startComposite.setEnabled(false);
            }
            if (this.m_controlComposite != null) {
                this.m_controlComposite.setEnabled(false);
            }
            if (this.m_executeComposite != null) {
                this.m_executeComposite.setEnabled(false);
            }
            if (this.m_fileComposite != null) {
                this.m_fileComposite.setEnabled(false);
            }
            if (this.m_startDelayComposite != null) {
                this.m_startDelayComposite.setEnabled(false);
            }
            if (this.m_endDelayComposite != null) {
                this.m_endDelayComposite.setEnabled(false);
            }
            this.m_endComposite.setEnabled(false);
            this.m_messageComposite.setEnabled(false);
            if (this.m_parameterComposite != null) {
                this.m_parameterComposite.setEnabled(false);
            }
        }
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void reflectJobInfo() {
        JobInfo info = this.m_jobTreeItem.getData();
        if (info instanceof JobInfo) {
            if (info.getId() != null) {
                this.m_jobIdText.setText(info.getId());
            } else {
                this.m_jobIdText.setText("");
            }
            if (info.getName() != null) {
                this.m_jobNameText.setText(info.getName());
            } else {
                this.m_jobNameText.setText("");
            }
            if (info.getDescription() != null) {
                this.m_jobAnnotationText.setText(info.getDescription());
            } else {
                this.m_jobAnnotationText.setText("");
            }
            if (info.getType() == 1) {
                this.m_startComposite.setWaitRuleInfo(info.getWaitRule());
                if (this.m_jobTreeItem.getParent() != null) {
                    this.m_startComposite.setParentJobId(this.m_jobTreeItem.getParent().getData().getId());
                }
                this.m_startComposite.setJobId(this.m_jobTreeItem.getData().getId());
                this.m_startComposite.reflectWaitRuleInfo();
                this.m_controlComposite.setWaitRuleInfo(info.getWaitRule());
                this.m_controlComposite.reflectWaitRuleInfo();
                this.m_startDelayComposite.setWaitRuleInfo(info.getWaitRule());
                this.m_startDelayComposite.reflectWaitRuleInfo();
                this.m_endDelayComposite.setWaitRuleInfo(info.getWaitRule());
                this.m_endDelayComposite.reflectWaitRuleInfo();
            } else if (info.getType() == 2) {
                this.m_startComposite.setWaitRuleInfo(info.getWaitRule());
                if (this.m_jobTreeItem.getParent() != null) {
                    this.m_startComposite.setParentJobId(this.m_jobTreeItem.getParent().getData().getId());
                }
                this.m_startComposite.setJobId(this.m_jobTreeItem.getData().getId());
                this.m_startComposite.reflectWaitRuleInfo();
                this.m_controlComposite.setWaitRuleInfo(info.getWaitRule());
                this.m_controlComposite.reflectWaitRuleInfo();
                this.m_executeComposite.setCommandInfo(info.getCommand());
                this.m_executeComposite.reflectCommandInfo();
                this.m_startDelayComposite.setWaitRuleInfo(info.getWaitRule());
                this.m_startDelayComposite.reflectWaitRuleInfo();
                this.m_endDelayComposite.setWaitRuleInfo(info.getWaitRule());
                this.m_endDelayComposite.reflectWaitRuleInfo();
            } else if (info.getType() == 3) {
                this.m_startComposite.setWaitRuleInfo(info.getWaitRule());
                if (this.m_jobTreeItem.getParent() != null) {
                    this.m_startComposite.setParentJobId(this.m_jobTreeItem.getParent().getData().getId());
                }
                this.m_startComposite.setJobId(this.m_jobTreeItem.getData().getId());
                this.m_startComposite.reflectWaitRuleInfo();
                this.m_controlComposite.setWaitRuleInfo(info.getWaitRule());
                this.m_controlComposite.reflectWaitRuleInfo();
                this.m_fileComposite.setFileInfo(info.getFile());
                this.m_fileComposite.reflectFileInfo();
                this.m_startDelayComposite.setWaitRuleInfo(info.getWaitRule());
                this.m_startDelayComposite.reflectWaitRuleInfo();
                this.m_endDelayComposite.setWaitRuleInfo(info.getWaitRule());
                this.m_endDelayComposite.reflectWaitRuleInfo();
            }
            this.m_endComposite.setEndInfo(info.getEndStatus());
            this.m_endComposite.reflectEndInfo();
            this.m_messageComposite.setNotificationsInfo(info.getNotifications());
            this.m_messageComposite.reflectNotificationsInfo();
            if (this.m_parameterComposite != null) {
                this.m_parameterComposite.setParamInfo(info.getParam());
                this.m_parameterComposite.reflectParamInfo();
            }
        }
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createJobInfo();
        if (result != null) {
            return result;
        }
        JobInfo info = this.m_jobTreeItem.getData();
        if (info instanceof JobInfo) {
            if (info.getType() == 1) {
                result = this.m_startComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_controlComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_startDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_endDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
            } else if (info.getType() == 2) {
                result = this.m_startComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_controlComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_executeComposite.createCommandInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_startDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_endDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
            } else if (info.getType() == 3) {
                result = this.m_startComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_controlComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_fileComposite.createFileInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_startDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_endDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
            }
            if ((result = this.m_endComposite.createEndInfo()) != null) {
                return result;
            }
            result = this.m_messageComposite.createNotificationsInfo();
            if (result != null) {
                return result;
            }
            if (info.getType() == 0 && (result = this.m_parameterComposite.createParamInfo()) != null) {
                return result;
            }
            if (this.m_startComposite != null) {
                info.setWaitRule(this.m_startComposite.getWaitRuleInfo());
            }
            if (this.m_controlComposite != null) {
                info.setWaitRule(this.m_controlComposite.getWaitRuleInfo());
            }
            if (this.m_executeComposite != null) {
                info.setCommand(this.m_executeComposite.getCommandInfo());
            }
            if (this.m_fileComposite != null) {
                info.setFile(this.m_fileComposite.getFileInfo());
            }
            if (this.m_endComposite != null) {
                info.setEndStatus(this.m_endComposite.getEndInfo());
            }
            if (this.m_startDelayComposite != null) {
                info.setWaitRule(this.m_startDelayComposite.getWaitRuleInfo());
            }
            if (this.m_endDelayComposite != null) {
                info.setWaitRule(this.m_endDelayComposite.getWaitRuleInfo());
            }
            if (this.m_messageComposite != null) {
                info.setNotifications(this.m_messageComposite.getNotificationsInfo());
            }
            if (this.m_parameterComposite != null) {
                info.setParam(this.m_parameterComposite.getParamInfo());
            }
        }
        return null;
    }

    private ValidateResult createJobInfo() {
        ValidateResult result = null;
        JobInfo info = this.m_jobTreeItem.getData();
        if (this.m_jobIdText.getText().length() > 0) {
            String oldId = info.getId();
            info.setId("");
            JobTreeItem top = JobUtil.getTopJobTreeItem((JobTreeItem)this.m_jobTreeItem);
            if (JobUtil.findJobId((String)this.m_jobIdText.getText(), (JobTreeItem)top)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                Object[] args1 = new String[]{this.m_jobIdText.getText()};
                result.setMessage(Messages.getString((String)"message.job.42", (Object[])args1));
                info.setId(oldId);
                return result;
            }
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.22"));
            return result;
        }
        info.setId(this.m_jobIdText.getText());
        if (this.m_jobNameText.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.23"));
            return result;
        }
        info.setName(this.m_jobNameText.getText());
        if (this.m_jobAnnotationText.getText().length() > 0) {
            info.setDescription(this.m_jobAnnotationText.getText());
        } else {
            info.setDescription("");
        }
        return null;
    }

    public JobTreeItem getJobTreeItem() {
        return this.m_jobTreeItem;
    }

    public void setJobTreeItem(JobTreeItem jobTreeItem) {
        this.m_jobTreeItem = jobTreeItem;
    }
}

