/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmp.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.snmp.action.AddSnmp;
import com.clustercontrol.snmp.action.DeleteSnmp;
import com.clustercontrol.snmp.action.GetSnmp;
import com.clustercontrol.snmp.action.ModifySnmp;
import com.clustercontrol.snmp.composite.SnmpListComposite;
import com.clustercontrol.snmp.dialog.SnmpCreateDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SnmpListDialog
extends CommonDialog {
    private SnmpListComposite snmpList = null;
    private Button buttonAddNumeric = null;
    private Button buttonAddString = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;
    private Button buttonValid = null;
    private Button buttonInvalid = null;

    public SnmpListDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(800, 400);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.snmp.list"));
        GridLayout layout = new GridLayout(7, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 7;
        parent.setLayout((Layout)layout);
        this.snmpList = new SnmpListComposite(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 6;
        this.snmpList.setLayoutData(gridData);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAddNumeric = this.createButton(composite, Messages.getString((String)"add"));
        this.buttonAddNumeric.addSelectionListener((SelectionListener)new AddSelectionListener(1));
        new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String monitorId = null;
                int monitorType = Integer.MAX_VALUE;
                Table table = SnmpListDialog.this.snmpList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        monitorId = (String)((ArrayList)item[0].getData()).get(0);
                        monitorType = MonitorTypeConstant.stringToType((String)((String)((ArrayList)item[0].getData()).get(3)));
                    }
                    catch (Exception exception) {}
                }
                if (monitorId != null) {
                    SnmpCreateDialog dialog = new SnmpCreateDialog(SnmpListDialog.this.getParentShell(), monitorId, monitorType);
                    if (dialog.open() == 0) {
                        boolean result = new ModifySnmp().modify(dialog.getInputData());
                        Object[] args = new String[]{monitorId};
                        if (result) {
                            MessageBox box = new MessageBox(SnmpListDialog.this.getShell(), 34);
                            box.setText(Messages.getString((String)"successful"));
                            box.setMessage(Messages.getString((String)"message.monitor.35", (Object[])args));
                            box.open();
                            int selectIndex = table.getSelectionIndex();
                            SnmpListDialog.this.snmpList.update();
                            table.setSelection(selectIndex);
                        } else {
                            MessageBox box = new MessageBox(SnmpListDialog.this.getShell(), 33);
                            box.setText(Messages.getString((String)"failed"));
                            box.setMessage(Messages.getString((String)"message.monitor.36", (Object[])args));
                            box.open();
                        }
                    }
                } else {
                    MessageBox box = new MessageBox(SnmpListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.1"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String monitorId = null;
                int monitorType = Integer.MAX_VALUE;
                Table table = SnmpListDialog.this.snmpList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        monitorId = (String)((ArrayList)item[0].getData()).get(0);
                        monitorType = MonitorTypeConstant.stringToType((String)((String)((ArrayList)item[0].getData()).get(3)));
                    }
                    catch (Exception exception) {}
                }
                if (monitorId != null) {
                    MessageBox confirmBox = new MessageBox(SnmpListDialog.this.getShell(), 296);
                    confirmBox.setText(Messages.getString((String)"confirmed"));
                    Object[] args = new String[]{monitorId};
                    String message = Messages.getString((String)"message.monitor.39", (Object[])args);
                    confirmBox.setMessage(message);
                    if (confirmBox.open() == 32) {
                        boolean result = new DeleteSnmp().delete(monitorId, monitorType);
                        if (result) {
                            MessageBox box = new MessageBox(SnmpListDialog.this.getShell(), 34);
                            box.setText(Messages.getString((String)"successful"));
                            box.setMessage(Messages.getString((String)"message.monitor.37", (Object[])args));
                            box.open();
                            SnmpListDialog.this.snmpList.update();
                        } else {
                            MessageBox box = new MessageBox(SnmpListDialog.this.getShell(), 33);
                            box.setText(Messages.getString((String)"failed"));
                            box.setMessage(Messages.getString((String)"message.monitor.38", (Object[])args));
                            box.open();
                        }
                    }
                } else {
                    MessageBox box = new MessageBox(SnmpListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.1"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        new Label(composite, 0);
        this.buttonValid = this.createButton(composite, Messages.getString((String)"valid"));
        this.buttonValid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnmpListDialog.this.setValid(1);
            }
        });
        this.buttonInvalid = this.createButton(composite, Messages.getString((String)"invalid"));
        this.buttonInvalid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnmpListDialog.this.setValid(0);
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        return super.validate();
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, Messages.getString((String)"close"), false);
    }

    public void setValid(int valid) {
        ArrayList<SnmpListComposite.SelectItem> list = this.snmpList.getSelectionData();
        if (list != null && list.size() > 0) {
            StringBuilder monitorIds = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    monitorIds.append(", ");
                }
                SnmpListComposite.SelectItem item = list.get(i);
                monitorIds.append(item.getMonitorId());
                ++i;
            }
            MessageBox confirmBox = new MessageBox(this.getShell(), 296);
            confirmBox.setText(Messages.getString((String)"confirmed"));
            Object[] confirmArgs = new String[]{monitorIds.toString()};
            if (valid == 1) {
                confirmBox.setMessage(Messages.getString((String)"message.monitor.47", (Object[])confirmArgs));
            } else {
                confirmBox.setMessage(Messages.getString((String)"message.monitor.48", (Object[])confirmArgs));
            }
            if (confirmBox.open() == 256) {
                return;
            }
            int i2 = 0;
            while (i2 < list.size()) {
                SnmpListComposite.SelectItem item = list.get(i2);
                if (item != null && !item.getMonitorId().equals("")) {
                    MonitorInfo info = new GetSnmp().getSnmp(item.getMonitorId(), item.getMonitorType());
                    info.setValid(valid);
                    boolean result = new ModifySnmp().modify(info);
                    if (!result) {
                        MessageBox box = new MessageBox(this.getShell(), 33);
                        box.setText(Messages.getString((String)"failed"));
                        Object[] args = new String[]{item.getMonitorId()};
                        box.setMessage(Messages.getString((String)"message.monitor.36", (Object[])args));
                        box.open();
                    }
                }
                ++i2;
            }
            int selectIndex = this.snmpList.getTableViewer().getTable().getSelectionIndex();
            this.snmpList.update();
            this.snmpList.getTableViewer().getTable().setSelection(selectIndex);
        } else {
            MessageBox box = new MessageBox(this.getShell(), 40);
            box.setText(Messages.getString((String)"warning"));
            box.setMessage(Messages.getString((String)"message.monitor.1"));
            box.open();
        }
    }

    class AddSelectionListener
    extends SelectionAdapter {
        private int m_monitorType;

        public AddSelectionListener(int monitorType) {
            this.m_monitorType = monitorType;
        }

        public void widgetSelected(SelectionEvent e) {
            MonitorInfo info;
            SnmpCreateDialog dialog = new SnmpCreateDialog(SnmpListDialog.this.getParentShell(), this.m_monitorType);
            if (dialog.open() == 0 && (info = dialog.getInputData()) != null) {
                boolean result = new AddSnmp().add(info);
                Object[] args = new String[]{info.getMonitorId()};
                if (result) {
                    MessageBox box = new MessageBox(SnmpListDialog.this.getShell(), 34);
                    box.setText(Messages.getString((String)"successful"));
                    box.setMessage(Messages.getString((String)"message.monitor.33", (Object[])args));
                    box.open();
                    SnmpListDialog.this.snmpList.update();
                } else {
                    MessageBox box = new MessageBox(SnmpListDialog.this.getShell(), 33);
                    box.setText(Messages.getString((String)"failed"));
                    box.setMessage(Messages.getString((String)"message.monitor.34", (Object[])args));
                    box.open();
                }
            }
        }
    }
}

