/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.internal.dialogs.EditorsPreferencePage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.LineDelimiterEditor;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IDEEditorsPreferencePage
extends EditorsPreferencePage {
    private boolean clearUserSettings = false;
    private ResourceEncodingFieldEditor encodingEditor;
    private LineDelimiterEditor lineSeparatorEditor;

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent);
        PreferenceLinkArea fileEditorsArea = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.FileEditors", IDEWorkbenchMessages.IDEEditorsPreferencePage_WorkbenchPreference_FileEditorsRelatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData(768);
        fileEditorsArea.getControl().setLayoutData((Object)data);
        PreferenceLinkArea contentTypeArea = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.ContentTypes", IDEWorkbenchMessages.IDEEditorsPreferencePage_WorkbenchPreference_contentTypesRelatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        data = new GridData(768);
        contentTypeArea.getControl().setLayoutData((Object)data);
        PreferenceLinkArea appearanceArea = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.Views", IDEWorkbenchMessages.IDEEditorsPreferencePage_WorkbenchPreference_viewsRelatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        data = new GridData(768);
        appearanceArea.getControl().setLayoutData((Object)data);
        this.createEditorHistoryGroup(composite);
        this.createSpace(composite);
        this.createShowMultipleEditorTabsPref(composite);
        this.createEditorReuseGroup(composite);
        Composite lower = new Composite(composite, 0);
        GridLayout lowerLayout = new GridLayout();
        lowerLayout.numColumns = 2;
        lowerLayout.makeColumnsEqualWidth = true;
        lower.setLayout((Layout)lowerLayout);
        lower.setLayoutData((Object)new GridData(768));
        Composite encodingComposite = new Composite(lower, 0);
        encodingComposite.setLayout((Layout)new GridLayout());
        encodingComposite.setLayoutData((Object)new GridData(768));
        this.encodingEditor = new ResourceEncodingFieldEditor(IDEWorkbenchMessages.WorkbenchPreference_encoding, encodingComposite, (IResource)ResourcesPlugin.getWorkspace().getRoot());
        this.encodingEditor.setPage((DialogPage)this);
        this.encodingEditor.load();
        this.encodingEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    IDEEditorsPreferencePage.this.updateValidState();
                }
            }
        });
        Composite lineComposite = new Composite(lower, 0);
        lineComposite.setLayout((Layout)new GridLayout());
        lineComposite.setLayoutData((Object)new GridData(768));
        this.lineSeparatorEditor = new LineDelimiterEditor(lineComposite);
        this.lineSeparatorEditor.doLoad();
        this.applyDialogFont(composite);
        return composite;
    }

    protected void performDefaults() {
        this.clearUserSettings = true;
        List encodings = WorkbenchEncoding.getDefinedEncodings();
        Collections.sort(encodings);
        this.encodingEditor.loadDefault();
        this.lineSeparatorEditor.loadDefault();
        super.performDefaults();
    }

    protected void updateValidState() {
        if (!this.encodingEditor.isValid()) {
            this.setValid(false);
            return;
        }
        super.updateValidState();
    }

    public boolean performOk() {
        if (this.clearUserSettings) {
            IDEEncoding.clearUserEncodings();
        }
        this.encodingEditor.store();
        this.lineSeparatorEditor.store();
        return super.performOk();
    }
}

