/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.dialog;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.performance.action.RecordDataWriter;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportDialog
extends Dialog {
    private Composite composite1;
    private Composite composite2;
    private Composite composite3;
    private Composite composite4;
    private FacilityTreeComposite treeComposite;
    private Label label = null;
    private Text filenameText = null;
    private Button button = null;
    private CollectorProperty property;
    private RecordDataWriter writer;

    public ExportDialog(Shell parent) {
        super(parent);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("EXPORT_DIALOG_TITLE"));
    }

    protected Control createDialogArea(Composite parent) {
        this.composite1 = (Composite)super.createDialogArea(parent);
        this.composite1.setLayout((Layout)new FillLayout());
        this.createComposite2();
        return this.composite1;
    }

    private void createComposite2() {
        this.composite2 = new Composite(this.composite1, 0);
        this.label = new Label(this.composite2, 0);
        this.createTree();
        this.createComposite3();
        this.createComposite4();
        this.createSeparator();
        this.composite2.setLayout((Layout)new GridLayout());
        this.label.setText(String.valueOf(Messages.getString("SCOPE")) + " : ");
    }

    private void createComposite3() {
        this.composite3 = new Composite(this.composite2, 0);
        GridData gridDataComposite3 = new GridData(768);
        this.composite3.setLayoutData((Object)gridDataComposite3);
        this.composite3.setLayout((Layout)new FormLayout());
        this.button = new Button(this.composite3, 32);
        this.button.setText(Messages.getString("OUTPUT_HEADER"));
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 0);
        buttonData.left = new FormAttachment(0, 0);
        this.button.setLayoutData((Object)buttonData);
    }

    private void createComposite4() {
        this.composite4 = new Composite(this.composite2, 0);
        GridData gridDataComposite3 = new GridData(768);
        this.composite4.setLayoutData((Object)gridDataComposite3);
        this.composite4.setLayout((Layout)new FormLayout());
        Label label = new Label(this.composite4, 0);
        label.setText(String.valueOf(Messages.getString("FILE_NAME")) + " : ");
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        label.setLayoutData((Object)labelData);
        Button button = new Button(this.composite4, 0);
        button.setText(Messages.getString("REFER"));
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        button.setLayoutData((Object)buttonData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog saveDialog = new FileDialog(ExportDialog.this.getShell(), 8192);
                String fileName = saveDialog.open();
                if (fileName != null) {
                    ExportDialog.this.filenameText.setText(fileName);
                }
            }
        });
        this.filenameText = new Text(this.composite4, 2048);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)label, 0);
        textData.right = new FormAttachment((Control)button, 0);
        this.filenameText.setLayoutData((Object)textData);
    }

    private void createTree() {
        FacilityTreeItem tree;
        this.treeComposite = new FacilityTreeComposite(this.composite2, 0);
        GridData gridDataTree = new GridData(1808);
        this.treeComposite.setLayoutData((Object)gridDataTree);
        if (this.property != null && this.property.getCollectorData() != null && (tree = this.property.getCollectorData().getFacilityTree()) != null) {
            this.treeComposite.setScopeTree(tree);
        }
    }

    private void createSeparator() {
        Label h_separator = new Label(this.composite2, 258);
        GridData gridDataLabel = new GridData(768);
        h_separator.setLayoutData((Object)gridDataLabel);
    }

    protected void okPressed() {
        String fileName = this.filenameText.getText();
        String facilityID = this.treeComposite.getSelectItem().getData().getFacilityId();
        if (facilityID == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("MSG_SPECIFY_SCOPE"));
            return;
        }
        if (fileName == null || fileName.equals("")) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("INPUT_ERROR"), (String)Messages.getString("MSG_SPECIFY_FILE_NAME"));
            return;
        }
        boolean headerFlag = this.button.getSelection();
        this.writer = new RecordDataWriter(fileName, this.property, facilityID, headerFlag);
        try {
            if (!this.writer.createNewFile()) {
                Object[] arg = new String[]{fileName};
                boolean check = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("MSG_REPLACE_FILE", arg));
                if (!check) {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("MSG_INVALID_FILE_NAME"));
            return;
        }
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Thread exportThread = new Thread(ExportDialog.this.writer);
                    exportThread.start();
                    monitor.beginTask(Messages.getString("EXPORT"), 100);
                    int progress = 0;
                    int buff = 0;
                    while (progress < 100) {
                        progress = ExportDialog.this.writer.getProgress();
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        Thread.sleep(50L);
                        monitor.worked(progress - buff);
                        buff = progress;
                    }
                    monitor.done();
                }
            };
            new ProgressMonitorDialog(this.getShell()).run(true, true, op);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("MSG_EXPORT_CANCEL"));
            this.writer.setCanceled(true);
        }
        super.okPressed();
    }

    public CollectorProperty getCollectorProperty() {
        return this.property;
    }

    public void setCollectorProperty(CollectorProperty property) {
        this.property = property;
    }
}

