/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.dao;

import com.clustercontrol.monitor.dao.EventMultiInfoDAO;
import com.clustercontrol.monitor.ejb.entity.EventMultiInfoBean;
import com.clustercontrol.monitor.ejb.entity.EventMultiInfoPK;
import com.clustercontrol.monitor.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventMultiInfoDAOImpl
implements EventMultiInfoDAO {
    protected static Log m_log = LogFactory.getLog(EventMultiInfoDAOImpl.class);

    public void init() {
    }

    public void load(EventMultiInfoPK pk, EventMultiInfoBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_event_multi_info WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ? AND multi_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.pluginId);
                stmt.setString(2, pk.monitorId);
                stmt.setString(3, pk.facilityId);
                stmt.setTimestamp(4, pk.outputDate);
                stmt.setString(5, pk.multiId);
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setPluginId(res.getString("plugin_id"));
                    ejb.setMonitorId(res.getString("monitor_id"));
                    ejb.setFacilityId(res.getString("facility_id"));
                    ejb.setOutputDate(res.getTimestamp("output_date"));
                    ejb.setMultiId(res.getString("multi_id"));
                    ejb.setDuplicationCount(res.getInt("duplication_count"));
                    break block13;
                }
                String msg = "EventMultiInfo data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(EventMultiInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_event_multi_info SET ");
                sql.append("duplication_count = ? ");
                sql.append("WHERE plugin_id = ? AND ");
                sql.append("monitor_id = ? AND ");
                sql.append("facility_id = ? AND ");
                sql.append("output_date = ? AND ");
                sql.append("multi_id = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setInt(1, ejb.getDuplicationCount());
                stmt.setString(2, ejb.getPluginId());
                stmt.setString(3, ejb.getMonitorId());
                stmt.setString(4, ejb.getFacilityId());
                stmt.setTimestamp(5, ejb.getOutputDate());
                stmt.setString(6, ejb.getMultiId());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId() + " SQLException"));
                e.printStackTrace();
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId() + " SQLException"));
                e1.printStackTrace();
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId() + " SQLException"));
            e1.printStackTrace();
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId()));
    }

    public void remove(EventMultiInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_event_multi_info WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ? AND multi_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.pluginId);
            stmt.setString(2, pk.monitorId);
            stmt.setString(3, pk.facilityId);
            stmt.setTimestamp(4, pk.outputDate);
            stmt.setString(5, pk.multiId);
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EventMultiInfoPK create(EventMultiInfoBean ejb) throws CreateException, EJBException {
        EventMultiInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_event_multi_info (");
                sql.append("plugin_id, ");
                sql.append("monitor_id, ");
                sql.append("facility_id, ");
                sql.append("output_date, ");
                sql.append("multi_id, ");
                sql.append("duplication_count) ");
                sql.append("values (?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getPluginId());
                stmt.setString(2, ejb.getMonitorId());
                stmt.setString(3, ejb.getFacilityId());
                stmt.setTimestamp(4, ejb.getOutputDate());
                stmt.setString(5, ejb.getMultiId());
                stmt.setInt(6, ejb.getDuplicationCount());
                int row = stmt.executeUpdate();
                pk = new EventMultiInfoPK(ejb.getMonitorId(), ejb.getPluginId(), ejb.getFacilityId(), ejb.getOutputDate(), ejb.getMultiId());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + ", " + ejb.getMultiId()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<EventMultiInfoPK> ret = new ArrayList<EventMultiInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_event_multi_info";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                EventMultiInfoPK pk = new EventMultiInfoPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"), res.getString("multi_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public EventMultiInfoPK findByPrimaryKey(EventMultiInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_event_multi_info WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ? AND multi_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.pluginId);
            stmt.setString(2, pk.monitorId);
            stmt.setString(3, pk.facilityId);
            stmt.setTimestamp(4, pk.outputDate);
            stmt.setString(5, pk.multiId);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            EventMultiInfoPK eventMultiInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return eventMultiInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }
}

