/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.util;

import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.OIDInfo;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;
import javax.ejb.EJBException;

public final class CalculationMethod {
    public static int NonDeviece = 0;
    public static int SingleDevice = 1;
    public static int MultiDevice = 2;
    private static long COUNTER32_MAX_VLUE = 0xFFFFFFFFL;
    private static HashMap m_OIDTable = new HashMap();
    private static String UPTIME_OID;
    private static Boolean initializeFlg;

    public static void initialize() {
        if (initializeFlg.booleanValue()) {
            return;
        }
        Properties properties = new Properties();
        try {
            String homedir = System.getProperty("jboss.server.home.dir");
            String propertyFile = homedir + File.separator + "conf" + File.separator + "performance.properties";
            properties.load(new FileInputStream(propertyFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        UPTIME_OID = properties.getProperty("collector.uptime.oid");
        StringBuffer buffer = new StringBuffer(UPTIME_OID);
        int itemNum = 0;
        while (properties.getProperty("collector.item.code." + itemNum) != null) {
            ++itemNum;
        }
        for (int i = 0; i < itemNum; ++i) {
            String itemCode = properties.getProperty("collector.item.code." + i);
            String operation = properties.getProperty("collector.method." + i);
            int OIDNum = 0;
            while (properties.getProperty("collector.oid." + i + '.' + OIDNum) != null) {
                ++OIDNum;
            }
            String[] oidBase = new String[OIDNum];
            String[] oidIndex = new String[OIDNum];
            int[] types = new int[OIDNum];
            for (int j = 0; j < OIDNum; ++j) {
                String fullOid = properties.getProperty("collector.oid." + i + '.' + j);
                buffer = new StringBuffer(fullOid);
                oidBase[j] = buffer.delete(buffer.lastIndexOf("."), buffer.length()).toString();
                buffer = new StringBuffer(fullOid);
                oidIndex[j] = buffer.delete(0, buffer.lastIndexOf(".") + 1).toString();
                types[j] = fullOid.endsWith(".*") ? MultiDevice : (fullOid.endsWith(".?") ? SingleDevice : NonDeviece);
            }
            Definition definition = new Definition(itemCode, operation, oidBase, oidIndex, types);
            m_OIDTable.put(itemCode, definition);
        }
        initializeFlg = new Boolean(true);
    }

    public static OIDInfo[] getTargetOid(String[] itemCodeList, int[] deviceIndexList) {
        CalculationMethod.initialize();
        TreeMap<String, OIDInfo> oidInfoMap = new TreeMap<String, OIDInfo>();
        oidInfoMap.put(CalculationMethod.getUPTimeOID(), CalculationMethod.getUPTimeOIDInfo());
        for (int i = 0; i < itemCodeList.length; ++i) {
            String[] oidBase = CalculationMethod.getOIDs(itemCodeList[i]);
            String[] oidIndex = CalculationMethod.getOidIndex(itemCodeList[i]);
            for (int j = 0; j < oidBase.length; ++j) {
                String fullOID;
                OIDInfo buffer = new OIDInfo();
                buffer.setBaseOid(oidBase[j]);
                if (oidIndex[j].equals("*")) {
                    fullOID = oidBase[j] + "." + "*";
                    buffer.setAllIndex(true);
                    oidInfoMap.put(fullOID, buffer);
                    continue;
                }
                if (oidIndex[j].equals("?")) {
                    fullOID = oidBase[j] + "." + deviceIndexList[i];
                    buffer.setOidIndex(deviceIndexList[i]);
                    buffer.setAllIndex(false);
                    oidInfoMap.put(fullOID, buffer);
                    continue;
                }
                fullOID = oidBase[j] + "." + oidIndex[j];
                buffer.setOidIndex(Integer.parseInt(oidIndex[j]));
                buffer.setAllIndex(false);
                oidInfoMap.put(fullOID, buffer);
            }
        }
        OIDInfo[] targetOID = new OIDInfo[oidInfoMap.values().size()];
        oidInfoMap.values().toArray(targetOID);
        return targetOID;
    }

    public static OIDInfo[] getTargetOid(CollectorItemInfo[] items) {
        CalculationMethod.initialize();
        TreeMap<String, OIDInfo> oidInfoMap = new TreeMap<String, OIDInfo>();
        oidInfoMap.put(CalculationMethod.getUPTimeOID(), CalculationMethod.getUPTimeOIDInfo());
        for (int i = 0; i < items.length; ++i) {
            String[] oidBase = CalculationMethod.getOIDs(items[i].getCollectorItemCode());
            String[] oidIndex = CalculationMethod.getOidIndex(items[i].getCollectorItemCode());
            for (int j = 0; j < oidBase.length; ++j) {
                String fullOID;
                OIDInfo buffer = new OIDInfo();
                buffer.setBaseOid(oidBase[j]);
                if (oidIndex[j].equals("*")) {
                    fullOID = oidBase[j] + "." + "*";
                    buffer.setAllIndex(true);
                    oidInfoMap.put(fullOID, buffer);
                    continue;
                }
                if (oidIndex[j].equals("?")) {
                    fullOID = oidBase[j] + "." + items[i].getDeviceIndex();
                    buffer.setOidIndex(items[i].getDeviceIndex());
                    buffer.setAllIndex(false);
                    oidInfoMap.put(fullOID, buffer);
                    continue;
                }
                fullOID = oidBase[j] + "." + oidIndex[j];
                buffer.setOidIndex(Integer.parseInt(oidIndex[j]));
                buffer.setAllIndex(false);
                oidInfoMap.put(fullOID, buffer);
            }
        }
        OIDInfo[] targetOID = new OIDInfo[oidInfoMap.values().size()];
        oidInfoMap.values().toArray(targetOID);
        return targetOID;
    }

    private static String[] getOIDs(String itemCode) {
        CalculationMethod.initialize();
        return ((Definition)m_OIDTable.get(itemCode)).getOIDs();
    }

    private static String[] getOidIndex(String itemCode) {
        CalculationMethod.initialize();
        return ((Definition)m_OIDTable.get(itemCode)).getOidIndex();
    }

    private static String getUPTimeOID() {
        CalculationMethod.initialize();
        return UPTIME_OID;
    }

    public static OIDInfo getUPTimeOIDInfo() {
        CalculationMethod.initialize();
        OIDInfo returnValue = new OIDInfo();
        StringBuffer buffer = new StringBuffer(UPTIME_OID);
        returnValue.setBaseOid(buffer.delete(buffer.lastIndexOf("."), buffer.length()).toString());
        buffer = new StringBuffer(UPTIME_OID);
        returnValue.setOidIndex(Integer.parseInt(buffer.delete(0, buffer.lastIndexOf(".") + 1).toString()));
        returnValue.setAllIndex(false);
        return returnValue;
    }

    public static double getPerformance(String itemCode, int deviceIndex, HashMap mibValue) {
        CalculationMethod.initialize();
        return ((Definition)m_OIDTable.get(itemCode)).calc(deviceIndex, mibValue);
    }

    static {
        initializeFlg = new Boolean(false);
    }

    public static class InvPercentage31
    extends Operation {
        public double calc(int deviceIndex) {
            if (this.getCurrentMibValue(0, deviceIndex) == 0L) {
                return Double.NaN;
            }
            long total = this.getCurrentMibValue(1, deviceIndex) + this.getCurrentMibValue(2, deviceIndex) + this.getCurrentMibValue(3, deviceIndex);
            double perfData = 100.0 - (double)total / (double)this.getCurrentMibValue(0, deviceIndex) * 100.0;
            return perfData;
        }
    }

    public static class InvPercentage
    extends Operation {
        public double calc(int deviceIndex) {
            if (this.getCurrentMibValue(1, deviceIndex) == 0L) {
                return Double.NaN;
            }
            double perfData = 100.0 - (double)this.getCurrentMibValue(0, deviceIndex) / (double)this.getCurrentMibValue(1, deviceIndex) * 100.0;
            return perfData;
        }
    }

    public static class Percentage
    extends Operation {
        public double calc(int deviceIndex) {
            if (this.getCurrentMibValue(1, deviceIndex) == 0L) {
                return Double.NaN;
            }
            double perfData = (double)this.getCurrentMibValue(0, deviceIndex) / (double)this.getCurrentMibValue(1, deviceIndex) * 100.0;
            return perfData;
        }
    }

    public static class Non
    extends Operation {
        public double calc(int deviceIndex) {
            return this.getCurrentMibValue(0, deviceIndex);
        }
    }

    public static class Sum
    extends Operation {
        public double calc(int deviceIndex) {
            return this.getCurrentMibValue(0, deviceIndex) + this.getCurrentMibValue(1, deviceIndex);
        }
    }

    public static class DividedBy100
    extends Operation {
        public double calc(int deviceIndex) {
            return (double)this.getCurrentMibValue(0, Integer.parseInt(this.getOIDIndex(0))) / 100.0;
        }
    }

    public static class PercentageDiffAdd
    extends Operation {
        public double calc(int deviceIndex) {
            long diff = this.getCurrentMibValue(0, deviceIndex) - this.getCurrentMibValue(2, deviceIndex);
            long total = this.getCurrentMibValue(0, deviceIndex) + this.getCurrentMibValue(1, deviceIndex);
            if (total == 0L) {
                return Double.NaN;
            }
            double perfData = (double)diff / (double)total * 100.0;
            return perfData;
        }
    }

    public static class TimeMeanPerTotalDividedBy2
    extends Operation {
        public double calc(int deviceIndex) {
            long totalDiff = 0L;
            if (this.getPreviousMibValue(0, 0) == 0L) {
                return Double.NaN;
            }
            long uptimeDiff = this.getCurrentMibValue(0, 0) - this.getPreviousMibValue(0, 0);
            if (uptimeDiff < 0L) {
                uptimeDiff = COUNTER32_MAX_VLUE + 1L + uptimeDiff;
            }
            if (uptimeDiff == 0L) {
                return Double.NaN;
            }
            long diff = 0L;
            for (int j = 1; j < this.getTableObjectCount(); ++j) {
                for (int i = 1; i < this.getOIDCountOfTableObject(j); ++i) {
                    diff = this.getCurrentMibValue(j, i) - this.getPreviousMibValue(j, i);
                    if (diff < 0L) {
                        diff = COUNTER32_MAX_VLUE + 1L + diff;
                    }
                    totalDiff += diff;
                }
            }
            double perfData = (double)totalDiff / (double)uptimeDiff * 100.0;
            return perfData / 2.0;
        }
    }

    public static class TimeMeanPerTotal
    extends Operation {
        public double calc(int deviceIndex) {
            long totalDiff = 0L;
            if (this.getPreviousMibValue(0, 0) == 0L) {
                return Double.NaN;
            }
            long uptimeDiff = this.getCurrentMibValue(0, 0) - this.getPreviousMibValue(0, 0);
            if (uptimeDiff < 0L) {
                uptimeDiff = COUNTER32_MAX_VLUE + 1L + uptimeDiff;
            }
            if (uptimeDiff == 0L) {
                return Double.NaN;
            }
            long diff = 0L;
            for (int j = 1; j < this.getTableObjectCount(); ++j) {
                for (int i = 1; i < this.getOIDCountOfTableObject(j); ++i) {
                    diff = this.getCurrentMibValue(j, i) - this.getPreviousMibValue(j, i);
                    if (diff < 0L) {
                        diff = COUNTER32_MAX_VLUE + 1L + diff;
                    }
                    totalDiff += diff;
                }
            }
            double perfData = (double)totalDiff / (double)uptimeDiff * 100.0;
            return perfData;
        }
    }

    public static class InvPercentage12
    extends Operation {
        public double calc(int deviceIndex) {
            long total = this.getCurrentMibValue(1, deviceIndex) + this.getCurrentMibValue(2, deviceIndex);
            if (total == 0L) {
                return Double.NaN;
            }
            double perfData = 100.0 - (double)this.getCurrentMibValue(0, deviceIndex) / (double)total * 100.0;
            return perfData;
        }
    }

    public static class InvPercentageOfTotal
    extends Operation {
        public double calc(int deviceIndex) {
            int i;
            long diffTotal = 0L;
            long targetDiff = this.getCurrentMibValue(0, deviceIndex) - this.getPreviousMibValue(0, deviceIndex);
            if (targetDiff < 0L) {
                targetDiff = COUNTER32_MAX_VLUE + 1L + targetDiff;
            }
            diffTotal = targetDiff;
            for (i = 1; i < this.getTableObjectCount(); ++i) {
                long diff = this.getCurrentMibValue(i, deviceIndex) - this.getPreviousMibValue(i, deviceIndex);
                if (diff < 0L) {
                    diff = COUNTER32_MAX_VLUE + 1L + diff;
                }
                diffTotal += diff;
            }
            if (diffTotal <= 100L && targetDiff == 0L) {
                return Double.NaN;
            }
            double perfData = (double)targetDiff / (double)diffTotal * 100.0;
            if (perfData == 0.0) {
                for (i = 0; i < this.getTableObjectCount(); ++i) {
                    long cur = this.getCurrentMibValue(i, deviceIndex);
                    long pre = this.getPreviousMibValue(i, deviceIndex);
                }
            }
            return 100.0 - perfData;
        }
    }

    public static class SumPerTotal
    extends Operation {
        public double calc(int deviceIndex) {
            long targetDiff2;
            long diffTotal = 0L;
            long targetDiff1 = this.getCurrentMibValue(0, deviceIndex) - this.getPreviousMibValue(0, deviceIndex);
            if (targetDiff1 < 0L) {
                targetDiff1 = COUNTER32_MAX_VLUE + 1L + targetDiff1;
            }
            if ((targetDiff2 = this.getCurrentMibValue(1, deviceIndex) - this.getPreviousMibValue(1, deviceIndex)) < 0L) {
                targetDiff2 = COUNTER32_MAX_VLUE + 1L + targetDiff2;
            }
            diffTotal = targetDiff1 + targetDiff2;
            for (int i = 2; i < this.getTableObjectCount(); ++i) {
                diffTotal += this.getCurrentMibValue(i, deviceIndex) - this.getPreviousMibValue(i, deviceIndex);
            }
            if (diffTotal == 0L) {
                return Double.NaN;
            }
            double perfData = (double)(targetDiff1 + targetDiff2) / (double)diffTotal * 100.0;
            return perfData;
        }
    }

    public static class PercentageOfTotal
    extends Operation {
        public double calc(int deviceIndex) {
            long diffTotal = 0L;
            long targetDiff = this.getCurrentMibValue(0, deviceIndex) - this.getPreviousMibValue(0, deviceIndex);
            if (targetDiff < 0L) {
                targetDiff = COUNTER32_MAX_VLUE + 1L + targetDiff;
            }
            diffTotal = targetDiff;
            for (int i = 1; i < this.getTableObjectCount(); ++i) {
                long diff = this.getCurrentMibValue(i, deviceIndex) - this.getPreviousMibValue(i, deviceIndex);
                if (diff < 0L) {
                    diff = COUNTER32_MAX_VLUE + 1L + diff;
                }
                diffTotal += diff;
            }
            if (diffTotal <= 100L && targetDiff == 0L) {
                return Double.NaN;
            }
            double perfData = (double)targetDiff / (double)diffTotal * 100.0;
            return perfData;
        }
    }

    public static class InvTimeMeanPercentage
    extends Operation {
        public double calc(int deviceIndex) {
            long uptimeDiff = this.getCurrentMibValue(0, 0) - this.getPreviousMibValue(0, 0);
            if (uptimeDiff < 0L) {
                uptimeDiff = COUNTER32_MAX_VLUE + 1L + uptimeDiff;
            }
            if (uptimeDiff == 0L) {
                return Double.NaN;
            }
            long valDirff = this.getCurrentMibValue(1, deviceIndex) - this.getPreviousMibValue(1, deviceIndex);
            if (valDirff < 0L) {
                valDirff = COUNTER32_MAX_VLUE + 1L + valDirff;
            }
            double perfData = (double)valDirff / (double)uptimeDiff * 100.0;
            return 100.0 - perfData;
        }
    }

    public static class TimeMeanSum
    extends Operation {
        public double calc(int deviceIndex) {
            long valDirff2;
            if (this.getPreviousMibValue(0, 0) == 0L) {
                return Double.NaN;
            }
            long uptimeDiff = this.getCurrentMibValue(0, 0) - this.getPreviousMibValue(0, 0);
            if (uptimeDiff < 0L) {
                uptimeDiff = COUNTER32_MAX_VLUE + 1L + uptimeDiff;
            }
            if (uptimeDiff == 0L) {
                return Double.NaN;
            }
            long valDirff1 = this.getCurrentMibValue(1, deviceIndex) - this.getPreviousMibValue(1, deviceIndex);
            if (valDirff1 < 0L) {
                valDirff1 = COUNTER32_MAX_VLUE + 1L + valDirff1;
            }
            if ((valDirff2 = this.getCurrentMibValue(2, deviceIndex) - this.getPreviousMibValue(2, deviceIndex)) < 0L) {
                valDirff2 = COUNTER32_MAX_VLUE + 1L + valDirff2;
            }
            double perfData = (double)(valDirff1 + valDirff2) / (double)uptimeDiff * 100.0;
            return perfData;
        }
    }

    public static class TimeMean
    extends Operation {
        public double calc(int deviceIndex) {
            if (this.getPreviousMibValue(0, 0) == 0L) {
                return Double.NaN;
            }
            long uptimeDiff = this.getCurrentMibValue(0, 0) - this.getPreviousMibValue(0, 0);
            if (uptimeDiff < 0L) {
                uptimeDiff = COUNTER32_MAX_VLUE + 1L + uptimeDiff;
            }
            if (uptimeDiff == 0L) {
                return Double.NaN;
            }
            long valDirff = this.getCurrentMibValue(1, deviceIndex) - this.getPreviousMibValue(1, deviceIndex);
            if (valDirff < 0L) {
                valDirff = COUNTER32_MAX_VLUE + 1L + valDirff;
            }
            double perfData = (double)valDirff / (double)uptimeDiff * 100.0;
            return perfData;
        }
    }

    public static class TimeMeanPercentage
    extends Operation {
        public double calc(int deviceIndex) {
            if (this.getPreviousMibValue(0, 0) == 0L) {
                return Double.NaN;
            }
            long uptimeDiff = this.getCurrentMibValue(0, 0) - this.getPreviousMibValue(0, 0);
            if (uptimeDiff < 0L) {
                uptimeDiff = COUNTER32_MAX_VLUE + 1L + uptimeDiff;
            }
            if (uptimeDiff == 0L) {
                return Double.NaN;
            }
            long valDirff = this.getCurrentMibValue(1, deviceIndex) - this.getPreviousMibValue(1, deviceIndex);
            if (valDirff < 0L) {
                valDirff = COUNTER32_MAX_VLUE + 1L + valDirff;
            }
            double perfData = (double)valDirff / (double)uptimeDiff * 100.0;
            return perfData;
        }
    }

    private static abstract class Operation {
        private String[] m_OIDBuffer;
        private String[] m_OIDIndex;
        private HashMap m_mibValueSetBuffer;

        private Operation() {
        }

        public abstract double calc(int var1);

        public void setOIDBuffer(String[] OIDBuffer) {
            this.m_OIDBuffer = OIDBuffer;
        }

        public void setOIDIndexBuffer(String[] OIDIndex) {
            this.m_OIDIndex = OIDIndex;
        }

        public String getOIDIndex(int index) {
            return this.m_OIDIndex[index];
        }

        public void setMibValueSetBuffer(HashMap mibValueSetBuffer) {
            this.m_mibValueSetBuffer = mibValueSetBuffer;
        }

        protected long getMibValue(int OIDIndex, int tableIndex, int timeIndex) {
            long[][] mibSet = (long[][])this.m_mibValueSetBuffer.get(this.m_OIDBuffer[OIDIndex]);
            if (mibSet == null || mibSet[tableIndex] == null || mibSet.length <= tableIndex) {
                return 0L;
            }
            return mibSet[tableIndex][timeIndex];
        }

        protected long[] getMibValueArray(int OIDIndex, int tableIndex) {
            long[][] mibSet = (long[][])this.m_mibValueSetBuffer.get(this.m_OIDBuffer[OIDIndex]);
            if (mibSet == null || mibSet[tableIndex] == null || mibSet.length <= tableIndex) {
                return null;
            }
            return mibSet[tableIndex];
        }

        protected long getCurrentMibValue(int OIDIndex, int tableIndex) {
            long[][] mibSet = (long[][])this.m_mibValueSetBuffer.get(this.m_OIDBuffer[OIDIndex]);
            if (mibSet == null || mibSet[tableIndex] == null || mibSet.length <= tableIndex) {
                return 0L;
            }
            return mibSet[tableIndex][1];
        }

        protected long getPreviousMibValue(int OIDIndex, int tableIndex) {
            long[][] mibSet = (long[][])this.m_mibValueSetBuffer.get(this.m_OIDBuffer[OIDIndex]);
            if (mibSet == null || mibSet[tableIndex] == null || mibSet.length <= tableIndex) {
                return 0L;
            }
            return mibSet[tableIndex][0];
        }

        public int getTableObjectCount() {
            return this.m_OIDBuffer.length;
        }

        protected int getOIDCountOfTableObject(int OIDIndex) {
            long[][] mibSet = (long[][])this.m_mibValueSetBuffer.get(this.m_OIDBuffer[OIDIndex]);
            return mibSet.length;
        }
    }

    public static class Definition {
        private String m_itemCode;
        private Operation m_operation;
        private String[] m_oidBase;
        private String[] m_oidIndex;
        private int[] m_types;

        public Definition(String itemCode, String operationType, String[] baseOIDs, String[] oidIndex, int[] types) {
            this.m_itemCode = itemCode;
            this.m_oidBase = baseOIDs;
            this.m_oidIndex = oidIndex;
            this.m_types = types;
            String operationClassName = "com.clustercontrol.performanceMGR.util.CalculationMethod$" + operationType;
            try {
                this.m_operation = (Operation)Class.forName(operationClassName).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new EJBException((Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new EJBException((Exception)e);
            }
            catch (InstantiationException e) {
                throw new EJBException((Exception)e);
            }
        }

        public synchronized double calc(int deviceIndex, HashMap mibValueSet) {
            this.m_operation.setOIDBuffer(this.m_oidBase);
            this.m_operation.setOIDIndexBuffer(this.m_oidIndex);
            this.m_operation.setMibValueSetBuffer(mibValueSet);
            double returnValue = this.m_operation.calc(deviceIndex);
            this.m_operation.setOIDBuffer(null);
            this.m_operation.setOIDIndexBuffer(null);
            this.m_operation.setMibValueSetBuffer(null);
            return returnValue;
        }

        public String getItemCode() {
            return this.m_itemCode;
        }

        public String[] getOidIndex() {
            return this.m_oidIndex;
        }

        public String getOidIndex(int index) {
            return this.m_oidIndex[index];
        }

        public String[] getOIDs() {
            return this.m_oidBase;
        }

        public String getOIDs(int index) {
            return this.m_oidBase[index];
        }

        public int[] getTypes() {
            return this.m_types;
        }

        public int getTypes(int index) {
            return this.m_types[index];
        }
    }
}

