/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.ejb.entity;

import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoHome;
import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoLocalHome;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class SystemNotifyEventInfoUtil {
    private static SystemNotifyEventInfoHome cachedRemoteHome = null;
    private static SystemNotifyEventInfoLocalHome cachedLocalHome = null;
    private static String hexServerIP = null;
    private static final SecureRandom seeder = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object lookupHome(Hashtable environment, String jndiName, Class narrowTo) throws NamingException {
        InitialContext initialContext = new InitialContext(environment);
        try {
            Object objRef = initialContext.lookup(jndiName);
            if (Remote.class.isAssignableFrom(narrowTo)) {
                Object object = PortableRemoteObject.narrow((Object)objRef, (Class)narrowTo);
                return object;
            }
            Object object = objRef;
            return object;
        }
        finally {
            initialContext.close();
        }
    }

    public static SystemNotifyEventInfoHome getHome() throws NamingException {
        if (cachedRemoteHome == null) {
            cachedRemoteHome = (SystemNotifyEventInfoHome)SystemNotifyEventInfoUtil.lookupHome(null, "SystemNotifyEventInfo", SystemNotifyEventInfoHome.class);
        }
        return cachedRemoteHome;
    }

    public static SystemNotifyEventInfoHome getHome(Hashtable environment) throws NamingException {
        return (SystemNotifyEventInfoHome)SystemNotifyEventInfoUtil.lookupHome(environment, "SystemNotifyEventInfo", SystemNotifyEventInfoHome.class);
    }

    public static SystemNotifyEventInfoLocalHome getLocalHome() throws NamingException {
        if (cachedLocalHome == null) {
            cachedLocalHome = (SystemNotifyEventInfoLocalHome)SystemNotifyEventInfoUtil.lookupHome(null, "SystemNotifyEventInfoLocal", SystemNotifyEventInfoLocalHome.class);
        }
        return cachedLocalHome;
    }

    public static final String generateGUID(Object o) {
        StringBuffer tmpBuffer = new StringBuffer(16);
        if (hexServerIP == null) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                System.err.println("SystemNotifyEventInfoUtil: Could not get the local IP address using InetAddress.getLocalHost()!");
                uhe.printStackTrace();
                return null;
            }
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP = SystemNotifyEventInfoUtil.hexFormat(SystemNotifyEventInfoUtil.getInt(serverIP), 8);
        }
        String hashcode = SystemNotifyEventInfoUtil.hexFormat(System.identityHashCode(o), 8);
        tmpBuffer.append(hexServerIP);
        tmpBuffer.append(hashcode);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = seeder.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(SystemNotifyEventInfoUtil.hexFormat(timeLow, 8));
        guid.append(tmpBuffer.toString());
        guid.append(SystemNotifyEventInfoUtil.hexFormat(node, 8));
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return SystemNotifyEventInfoUtil.padHex(s, j) + s;
    }

    private static String padHex(String s, int i) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                tmpBuffer.append('0');
            }
        }
        return tmpBuffer.toString();
    }
}

