/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.ejb.session;

import com.clustercontrol.performanceMGR.ejb.bmp.Collector;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorHome;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.performanceMGR.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

public class CollectorRunControllerBean
implements SessionBean {
    private static final long serialVersionUID = 1L;
    protected static Log m_log = LogFactory.getLog(CollectorRunControllerBean.class);

    public void managePresavePeriod() throws FinderException, NamingException {
        m_log.debug((Object)"managePresavePeriod() :  start");
        CollectorHome home = JNDIConnectionManager.getCollectorHome();
        try {
            Collection myBeans = home.findByPresave();
            for (Collector bean : myBeans) {
                if (bean.getPresavePeriod() < 0) continue;
                Calendar cal = Calendar.getInstance();
                cal.add(5, -bean.getPresavePeriod());
                cal.set(14, 0);
                cal.set(13, 0);
                Date startDate = cal.getTime();
                m_log.debug((Object)("managePresavePeriod() :  presaveDate  " + startDate.toString()));
                if (!startDate.after(bean.getStartDate())) continue;
                bean.setStartTime(startDate.getTime());
                bean.managePresave(startDate);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (FinderException e) {
            e.printStackTrace();
        }
        m_log.debug((Object)"managePresavePeriod() :  end");
    }

    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("CollectorRunController", "PERF_COLLECT");
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("addQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        JobDetail job = new JobDetail("CollectorRunController", "PERF_COLLECT", EJBInvokerJob.class);
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            job.getJobDataMap().put("java.naming.provider.url", "jnp://localhost:1100");
        }
        job.setDurability(true);
        job.getJobDataMap().put("ejb", "CollectorRunController");
        job.getJobDataMap().put("method", "managePresavePeriod");
        CronTrigger cronTrigger = new CronTrigger("CollectorRunController", "PERF_COLLECT");
        cronTrigger.setCronExpression(cronString);
        try {
            manager.addSchedule(job, (Trigger)cronTrigger);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("CollectorRunController", "PERF_COLLECT");
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("deleteQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }
}

