/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.monitor;

import com.clustercontrol.monitor.message.LogOutputBasicInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.monitor.MonitorBase;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public class MonitorJboss
extends MonitorBase {
    private static Log log = LogFactory.getLog(MonitorJboss.class);
    protected static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    protected static final String OBJECT_NAME = "jboss:service=HinemosPartition";
    protected static final String OPERATION_NAME = "getCurrentView";

    public void run() {
        log.debug((Object)"run() start :");
        boolean server1 = false;
        boolean server2 = false;
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME);
            Object returnObject = server.invoke(name, OPERATION_NAME, null, null);
            if (returnObject instanceof Vector) {
                Vector returnVector = (Vector)returnObject;
                for (int i = 0; i < returnVector.size(); ++i) {
                    String work = (String)returnVector.get(i);
                    String[] node = work.split(":");
                    if (node[0].equals(this.troubleDetectionInfo.getJbossServer1())) {
                        server1 = true;
                        continue;
                    }
                    if (!node[0].equals(this.troubleDetectionInfo.getJbossServer2())) continue;
                    server2 = true;
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)("run() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)("run() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.error((Object)("run() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            log.error((Object)("run() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            log.error((Object)("run() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            log.error((Object)("run() : " + e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)("run() : " + e.getMessage()));
        }
        this.logout(server1, server2);
        log.debug((Object)"run() end :");
    }

    protected void logout(boolean server1, boolean server2) {
        String application = NotifyMessages.getString("jboss.application");
        OutputLog output = new OutputLog(this.troubleDetectionInfo);
        if (server1 && server2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("JBOSS01");
            info.setMessageId("001");
            info.setMessage(NotifyMessages.getString("jboss01.001.message"));
            Object[] args = new String[]{this.troubleDetectionInfo.getJbossServer1(), this.troubleDetectionInfo.getJbossServer2()};
            info.setMessageOrg(NotifyMessages.getString("jboss01.001.org.message", args));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("jboss01.001.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (server1 && !server2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("JBOSS01");
            info.setMessageId("002");
            Object[] args1 = new String[]{this.troubleDetectionInfo.getJbossServer2()};
            info.setMessage(NotifyMessages.getString("jboss01.002.message", args1));
            Object[] args2 = new String[]{this.troubleDetectionInfo.getJbossServer1(), this.troubleDetectionInfo.getJbossServer2()};
            info.setMessageOrg(NotifyMessages.getString("jboss01.002.org.message", args2));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("jboss01.002.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (!server1 && server2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("JBOSS01");
            info.setMessageId("002");
            Object[] args1 = new String[]{this.troubleDetectionInfo.getJbossServer1()};
            info.setMessage(NotifyMessages.getString("jboss01.002.message", args1));
            Object[] args2 = new String[]{this.troubleDetectionInfo.getJbossServer2(), this.troubleDetectionInfo.getJbossServer1()};
            info.setMessageOrg(NotifyMessages.getString("jboss01.002.org.message", args2));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("jboss01.002.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        }
    }

    public void logout(String monitorId, String messageId) {
        String application = NotifyMessages.getString("jboss.application");
        String key = monitorId.toLowerCase() + "." + messageId;
        OutputLog output = new OutputLog(this.troubleDetectionInfo);
        LogOutputInfo info = new LogOutputInfo();
        info.setPluginId("SYSMON");
        info.setApplication(application);
        info.setMonitorId(monitorId);
        info.setMessageId(messageId);
        if (key.equals("jboss02.001")) {
            Object[] args1 = new String[]{this.troubleDetectionInfo.getJbossServer1(), this.troubleDetectionInfo.getJbossServer2()};
            info.setMessage(NotifyMessages.getString(key + ".message", args1));
            Object[] args2 = new String[]{this.troubleDetectionInfo.getJbossServer1(), this.troubleDetectionInfo.getJbossServer2()};
            info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
        } else if (key.equals("jboss03.001")) {
            Object[] args1 = new String[]{this.troubleDetectionInfo.getJbossServer2(), this.troubleDetectionInfo.getJbossServer1()};
            info.setMessage(NotifyMessages.getString(key + ".message", args1));
            Object[] args2 = new String[]{this.troubleDetectionInfo.getJbossServer2(), this.troubleDetectionInfo.getJbossServer1()};
            info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
        } else {
            info.setMessage(NotifyMessages.getString(key + ".message"));
            info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
        }
        info.setFacilityId("SYSTEM");
        info.setScopeText("");
        info.setPriority(this.getPriority(NotifyMessages.getString(key + ".priority")));
        info.setGenerationDate(new Date());
        output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
    }
}

