/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.monitor;

import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.troubledetection.monitor.MonitorForest;
import com.clustercontrol.troubledetection.monitor.MonitorJboss;
import com.clustercontrol.troubledetection.monitor.MonitorLdap;
import com.clustercontrol.troubledetection.monitor.MonitorSyslogForward;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MonitorTask
extends TimerTask {
    private static Log log = LogFactory.getLog(MonitorTask.class);
    protected TroubleDetectionInfo troubleDetectionInfo = null;
    protected NotifyInfo notifyInfo = null;

    public void run() {
        log.debug((Object)"run() start :");
        MonitorJboss jboss = new MonitorJboss();
        jboss.setTroubleDetectionInfo(this.troubleDetectionInfo);
        jboss.setNotifyInfo(this.notifyInfo);
        jboss.run();
        MonitorLdap ldap = new MonitorLdap();
        ldap.setTroubleDetectionInfo(this.troubleDetectionInfo);
        ldap.setNotifyInfo(this.notifyInfo);
        ldap.run();
        MonitorForest forest = new MonitorForest();
        forest.setTroubleDetectionInfo(this.troubleDetectionInfo);
        forest.setNotifyInfo(this.notifyInfo);
        forest.run();
        MonitorSyslogForward syslogForward = new MonitorSyslogForward();
        syslogForward.setTroubleDetectionInfo(this.troubleDetectionInfo);
        syslogForward.setNotifyInfo(this.notifyInfo);
        syslogForward.run();
        log.debug((Object)"run() end :");
    }

    public void setTroubleDetectionInfo(TroubleDetectionInfo info) {
        this.troubleDetectionInfo = info;
    }

    public void setNotifyInfo(NotifyInfo info) {
        this.notifyInfo = info;
    }
}

