/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.output;

import com.clustercontrol.monitor.factory.CreateLogOutputInfo;
import com.clustercontrol.monitor.message.LogOutputBasicInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.ParallelLogOutputInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.troubledetection.output.OutputControl;
import com.clustercontrol.troubledetection.output.OutputEvent;
import com.clustercontrol.troubledetection.output.OutputFile;
import com.clustercontrol.troubledetection.output.OutputStatus;
import com.clustercontrol.troubledetection.util.MailManager;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputLog {
    private static Log log = LogFactory.getLog(OutputLog.class);
    protected TroubleDetectionInfo troubleDetectionInfo;

    public OutputLog(TroubleDetectionInfo info) {
        this.troubleDetectionInfo = info;
    }

    public void outputLog(NotifyInfo notifyInfo, LogOutputBasicInfo basicInfo) {
        if (notifyInfo != null) {
            LogOutputInfo info = new CreateLogOutputInfo().get(notifyInfo, basicInfo);
            this.outputLog(info);
        }
    }

    public synchronized void outputLog(LogOutputInfo info) {
        log.debug((Object)("outputLog start : MonitorId=" + info.getMonitorId() + ", MessageId" + info.getMessageId()));
        if (!(info instanceof LogOutputInfo)) {
            return;
        }
        Date now = new Date();
        Timestamp outputDate = new Timestamp(now.getTime());
        OutputControl control = new OutputControl();
        control.control(info, outputDate);
        OutputStatus status = new OutputStatus();
        for (int i = 0; i < this.troubleDetectionInfo.getRetryStatus() && !status.outputStatusInfo(info, control.getOutputDate()); ++i) {
        }
        if (control.isInsertFlg()) {
            int inhibitedFlg = 0;
            if (control.isUpdateFlg()) {
                inhibitedFlg = 1;
            }
            OutputEvent event = new OutputEvent();
            for (int i = 0; i < this.troubleDetectionInfo.getRetryEvent() && !event.output(info, outputDate, inhibitedFlg); ++i) {
            }
        }
        if (control.isInsertFlg() && !control.isUpdateFlg()) {
            String[] address = info.getAddress();
            if (address != null && address.length > 0) {
                ParallelLogOutputInfo parallelInfo = new ParallelLogOutputInfo();
                parallelInfo.setLogOutputInfo(info);
                parallelInfo.setOutputDate(outputDate);
                MailManager.getMailManager().add(parallelInfo);
            }
            OutputFile file = new OutputFile();
            file.output(info);
        }
        log.debug((Object)("outputLog end : MonitorId=" + info.getMonitorId() + ", MessageId" + info.getMessageId()));
    }
}

