/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.output;

import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoPK;
import com.clustercontrol.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.ejb.FinderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputStatus {
    private static Log log = LogFactory.getLog(OutputStatus.class);

    public boolean outputStatusInfo(LogOutputInfo logOutput, Timestamp outputDate) {
        log.debug((Object)("outputStatusInfo start : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId()));
        boolean result = false;
        if (logOutput.isStatusInfoFlg()) {
            StatusInfoLocal statusInfo = null;
            boolean insertFlg = false;
            try {
                StatusInfoPK pk = new StatusInfoPK(logOutput.getMonitorId(), logOutput.getPluginId(), logOutput.getFacilityId());
                statusInfo = StatusInfoUtil.getLocalHome().findByPrimaryKey(pk);
            }
            catch (FinderException e) {
                insertFlg = true;
            }
            catch (Exception e) {
                log.error((Object)("outputStatusInfo():" + e.getMessage()));
                insertFlg = true;
            }
            try {
                if (insertFlg) {
                    log.debug((Object)("outputStatusInfo insert : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId()));
                    this.insertStatusInfo(logOutput, outputDate);
                    result = true;
                } else {
                    log.debug((Object)("outputStatusInfo update : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId()));
                    this.updateStatusInfo(statusInfo, logOutput, outputDate);
                    result = true;
                }
            }
            catch (Exception e) {
                log.error((Object)("outputStatusInfo():" + e.getMessage()));
            }
        }
        log.debug((Object)("outputStatusInfo end : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId()));
        return result;
    }

    public void insertStatusInfo(LogOutputInfo logOutput, Timestamp outputDate) throws Exception {
        Integer expirationFlg = this.getExpirationFlg(logOutput);
        Timestamp expirationDate = null;
        if (expirationFlg != null) {
            expirationDate = this.getExpirationDate(logOutput, outputDate);
        }
        StatusInfoUtil.getLocalHome().create(logOutput.getFacilityId(), logOutput.getMonitorId(), logOutput.getPluginId(), logOutput.getApplication(), logOutput.getMessageId(), logOutput.getMessage(), new Integer(logOutput.getPriority()), new Timestamp(logOutput.getGenerationDate().getTime()), outputDate, expirationFlg, expirationDate);
    }

    public void updateStatusInfo(StatusInfoLocal statusInfo, LogOutputInfo logOutput, Timestamp outputDate) throws Exception {
        if (statusInfo != null) {
            Integer expirationFlg = this.getExpirationFlg(logOutput);
            Timestamp expirationDate = null;
            if (expirationFlg != null) {
                expirationDate = this.getExpirationDate(logOutput, outputDate);
            }
            statusInfo.setApplication(logOutput.getApplication());
            statusInfo.setMessageId(logOutput.getMessageId());
            statusInfo.setMessage(logOutput.getMessage());
            statusInfo.setPriority(new Integer(logOutput.getPriority()));
            statusInfo.setOutputDate(outputDate);
            statusInfo.setExpirationFlg(expirationFlg);
            statusInfo.setExpirationDate(expirationDate);
        }
    }

    private Integer getExpirationFlg(LogOutputInfo logOutput) {
        Integer expirationFlg = null;
        if (logOutput != null) {
            if (11 == logOutput.getStatusInvalidFlg()) {
                expirationFlg = new Integer(logOutput.getStatusInvalidFlg());
            }
            if (12 == logOutput.getStatusInvalidFlg()) {
                expirationFlg = new Integer(logOutput.getStatusUpdatePriority());
            }
        }
        return expirationFlg;
    }

    private Timestamp getExpirationDate(LogOutputInfo logOutput, Timestamp outputDate) {
        Timestamp expirationDate = null;
        if (logOutput != null && logOutput.getStatusValidPeriod() > 0) {
            Calendar cal = null;
            cal = Calendar.getInstance();
            cal.setTime(outputDate);
            cal.add(12, logOutput.getStatusValidPeriod());
            expirationDate = new Timestamp(cal.getTimeInMillis());
        }
        return expirationDate;
    }
}

