/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.util;

import com.clustercontrol.monitor.message.ParallelLogOutputInfo;
import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.troubledetection.util.SendMail;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailManager
extends Thread {
    private static SendMail sender = new SendMail();
    private LinkedList<Object> m_infoList = new LinkedList();
    private boolean m_waiting = false;
    private TroubleDetectionInfo troubleDetectionInfo;
    private Log log = LogFactory.getLog(this.getClass());
    private static MailManager instance = null;

    public static synchronized MailManager getMailManager() {
        if (instance == null) {
            instance = new MailManager();
        }
        return instance;
    }

    private MailManager() {
    }

    public void setTroubleDetectionInfo(TroubleDetectionInfo info) {
        this.troubleDetectionInfo = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.log.debug((Object)"Thread Start");
        while (true) {
            Object info = null;
            MailManager mailManager = this;
            synchronized (mailManager) {
                info = this.getInfo();
                if (info == null) {
                    this.log.debug((Object)"run() : Waiting for processing...");
                    this.m_waiting = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    this.m_waiting = false;
                    continue;
                }
            }
            if (!(info instanceof ParallelLogOutputInfo)) continue;
            this.proccess((ParallelLogOutputInfo)info);
        }
        this.terminate();
        this.log.debug((Object)"Thread End");
    }

    protected void proccess(ParallelLogOutputInfo info) {
        for (int i = 0; i < this.troubleDetectionInfo.getRetryMail(); ++i) {
            this.log.debug((Object)("proccess() :" + info));
            if (sender.sendMail(info.getLogOutputInfo().getAddress(), info.getLogOutputInfo(), info.getOutputDate())) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) {
        boolean notifyFlg = false;
        Object object = this.m_infoList;
        synchronized (object) {
            if (this.m_infoList.size() == 0) {
                notifyFlg = true;
            }
            if (obj instanceof ParallelLogOutputInfo) {
                this.m_infoList.add(obj);
            }
        }
        if (notifyFlg && this.isWaiting()) {
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getInfo() {
        LinkedList<Object> linkedList = this.m_infoList;
        synchronized (linkedList) {
            try {
                return this.m_infoList.removeFirst();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }

    public synchronized boolean isWaiting() {
        return this.m_waiting;
    }

    private void terminate() {
    }
}

