/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol;

import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.ejb.session.MonitorControllerHome;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MonitorSetup {
    public static final String QUARTZ_NAME = "Quartz";

    public static void main(String[] args) {
        MonitorSetup setup = new MonitorSetup();
        try {
            setup.setup(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setup(String[] args) throws Exception {
        if (args.length != 2 && args.length != 3) {
            return;
        }
        InitialContext context = this.getContext("jnp://" + args[1]);
        MonitorControllerHome home = (MonitorControllerHome)context.lookup("MonitorController");
        MonitorController monitorController = home.create();
        if (args[0].compareTo("add") == 0) {
            monitorController.addQuartz(args[2]);
        } else if (args[0].compareTo("del") == 0) {
            monitorController.deleteQuartz();
        }
    }

    private InitialContext getContext(String url) throws NamingException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        props.put("java.naming.provider.url", url);
        InitialContext initialContext = new InitialContext(props);
        return initialContext;
    }
}

